/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.ZNRecordDelta;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ZNRecord {
    static Logger _logger = Logger.getLogger(ZNRecord.class);
    private final String id;
    @JsonIgnore(value=true)
    public static final String LIST_FIELD_BOUND = "listField.bound";
    @JsonIgnore(value=true)
    public static final int SIZE_LIMIT = 1024000;
    private List<ZNRecordDelta> _deltaList = new ArrayList<ZNRecordDelta>();
    private Map<String, String> simpleFields;
    private Map<String, Map<String, String>> mapFields;
    private Map<String, List<String>> listFields;
    private int _version;
    private long _creationTime;
    private long _modifiedTime;

    @JsonCreator
    public ZNRecord(@JsonProperty(value="id") String id) {
        this.id = id;
        this.simpleFields = new TreeMap<String, String>();
        this.mapFields = new TreeMap<String, Map<String, String>>();
        this.listFields = new TreeMap<String, List<String>>();
    }

    public ZNRecord(ZNRecord record) {
        this(record, record.getId());
    }

    public ZNRecord(ZNRecord record, String id) {
        this(id);
        this.simpleFields.putAll(record.getSimpleFields());
        this.mapFields.putAll(record.getMapFields());
        this.listFields.putAll(record.getListFields());
        this._version = record.getVersion();
        this._creationTime = record.getCreationTime();
        this._modifiedTime = record.getModifiedTime();
    }

    public ZNRecord(ZNRecord record, int version) {
        this(record);
        this._version = version;
    }

    @JsonIgnore(value=true)
    public void setDeltaList(List<ZNRecordDelta> deltaList) {
        this._deltaList = deltaList;
    }

    @JsonIgnore(value=true)
    public List<ZNRecordDelta> getDeltaList() {
        return this._deltaList;
    }

    @JsonProperty
    public Map<String, String> getSimpleFields() {
        return this.simpleFields;
    }

    @JsonProperty
    public void setSimpleFields(Map<String, String> simpleFields) {
        this.simpleFields = simpleFields;
    }

    @JsonProperty
    public Map<String, Map<String, String>> getMapFields() {
        return this.mapFields;
    }

    @JsonProperty
    public void setMapFields(Map<String, Map<String, String>> mapFields) {
        this.mapFields = mapFields;
    }

    @JsonProperty
    public Map<String, List<String>> getListFields() {
        return this.listFields;
    }

    @JsonProperty
    public void setListFields(Map<String, List<String>> listFields) {
        this.listFields = listFields;
    }

    @JsonProperty
    public void setSimpleField(String k, String v) {
        this.simpleFields.put(k, v);
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setMapField(String k, Map<String, String> v) {
        this.mapFields.put(k, v);
    }

    public void setListField(String k, List<String> v) {
        this.listFields.put(k, v);
    }

    public String getSimpleField(String k) {
        return this.simpleFields.get(k);
    }

    public Map<String, String> getMapField(String k) {
        return this.mapFields.get(k);
    }

    public List<String> getListField(String k) {
        return this.listFields.get(k);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.id + ", ");
        if (this.simpleFields != null) {
            sb.append(this.simpleFields);
        }
        if (this.mapFields != null) {
            sb.append(this.mapFields);
        }
        if (this.listFields != null) {
            sb.append(this.listFields);
        }
        return sb.toString();
    }

    public void merge(ZNRecord record) {
        if (record == null) {
            return;
        }
        if (record.getDeltaList().size() > 0) {
            _logger.info((Object)("Merging with delta list, recordId = " + this.id + " other:" + record.getId()));
            this.merge(record.getDeltaList());
            return;
        }
        this.simpleFields.putAll(record.simpleFields);
        for (String key : record.mapFields.keySet()) {
            Map<String, String> map = this.mapFields.get(key);
            if (map != null) {
                map.putAll(record.mapFields.get(key));
                continue;
            }
            this.mapFields.put(key, record.mapFields.get(key));
        }
        for (String key : record.listFields.keySet()) {
            List<String> list = this.listFields.get(key);
            if (list != null) {
                list.addAll((Collection<String>)record.listFields.get(key));
                continue;
            }
            this.listFields.put(key, record.listFields.get(key));
        }
    }

    void merge(ZNRecordDelta delta) {
        if (delta.getMergeOperation() == ZNRecordDelta.MergeOperation.ADD) {
            this.merge(delta.getRecord());
        } else if (delta.getMergeOperation() == ZNRecordDelta.MergeOperation.SUBTRACT) {
            this.subtract(delta.getRecord());
        }
    }

    void merge(List<ZNRecordDelta> deltaList) {
        for (ZNRecordDelta delta : deltaList) {
            this.merge(delta);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZNRecord)) {
            return false;
        }
        ZNRecord that = (ZNRecord)obj;
        if (this.getSimpleFields().size() != that.getSimpleFields().size()) {
            return false;
        }
        if (this.getMapFields().size() != that.getMapFields().size()) {
            return false;
        }
        if (this.getListFields().size() != that.getListFields().size()) {
            return false;
        }
        if (!((Object)this.getSimpleFields()).equals(that.getSimpleFields())) {
            return false;
        }
        if (!((Object)this.getMapFields()).equals(that.getMapFields())) {
            return false;
        }
        return ((Object)this.getListFields()).equals(that.getListFields());
    }

    public void subtract(ZNRecord value) {
        for (String key : value.getSimpleFields().keySet()) {
            if (!this.simpleFields.containsKey(key)) continue;
            this.simpleFields.remove(key);
        }
        for (String key : value.getListFields().keySet()) {
            if (!this.listFields.containsKey(key)) continue;
            this.listFields.remove(key);
        }
        for (String key : value.getMapFields().keySet()) {
            if (!this.mapFields.containsKey(key)) continue;
            this.mapFields.remove(key);
        }
    }

    @JsonIgnore(value=true)
    public int getVersion() {
        return this._version;
    }

    @JsonIgnore(value=true)
    public void setVersion(int version) {
        this._version = version;
    }

    @JsonIgnore(value=true)
    public long getCreationTime() {
        return this._creationTime;
    }

    @JsonIgnore(value=true)
    public void setCreationTime(long creationTime) {
        this._creationTime = creationTime;
    }

    @JsonIgnore(value=true)
    public long getModifiedTime() {
        return this._modifiedTime;
    }

    @JsonIgnore(value=true)
    public void setModifiedTime(long modifiedTime) {
        this._modifiedTime = modifiedTime;
    }
}

