/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.IdealState;

public abstract class IdealStateBuilder {
    private String resourceName;
    private int numPartitions;
    private int numReplica;
    private String stateModel;
    private String stateModelFactoryName = "DEFAULT";
    protected IdealState.IdealStateModeProperty mode;
    private int maxPartitionsPerNode;
    private String nodeGroup = "*";
    protected ZNRecord _record;

    public IdealStateBuilder(String resourceName) {
        this.resourceName = resourceName;
        this._record = new ZNRecord(resourceName);
    }

    public IdealStateBuilder setNumReplica(int numReplica) {
        this.numReplica = numReplica;
        return this;
    }

    public IdealStateBuilder setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    public IdealStateBuilder setStateModel(String stateModel) {
        this.stateModel = stateModel;
        return this;
    }

    public IdealStateBuilder setStateModelFactoryName(String stateModelFactoryName) {
        this.stateModelFactoryName = stateModelFactoryName;
        return this;
    }

    public IdealStateBuilder setMaxPartitionsPerNode(int maxPartitionsPerNode) {
        this.maxPartitionsPerNode = maxPartitionsPerNode;
        return this;
    }

    public IdealStateBuilder setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
        return this;
    }

    public IdealStateBuilder setMode(IdealState.IdealStateModeProperty mode) {
        this.mode = mode;
        return this;
    }

    public IdealState build() {
        IdealState idealstate = new IdealState(this._record);
        idealstate.setNumPartitions(this.numPartitions);
        idealstate.setMaxPartitionsPerInstance(this.maxPartitionsPerNode);
        idealstate.setStateModelDefRef(this.stateModel);
        idealstate.setStateModelFactoryName(this.stateModelFactoryName);
        idealstate.setIdealStateMode(this.mode.toString());
        idealstate.setReplicas("" + this.numReplica);
        if (!idealstate.isValid()) {
            throw new HelixException("invalid ideal-state: " + idealstate);
        }
        return idealstate;
    }
}

