/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.util.Map;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.monitoring.mbeans.ResourceMonitorMBean;
import org.apache.log4j.Logger;

public class ResourceMonitor
implements ResourceMonitorMBean {
    int _numOfPartitions;
    int _numOfPartitionsInExternalView;
    int _numOfErrorPartitions;
    int _externalViewIdealStateDiff;
    private static final Logger LOG = Logger.getLogger(ResourceMonitor.class);
    String _resourceName;
    String _clusterName;

    public ResourceMonitor(String clusterName, String resourceName) {
        this._clusterName = clusterName;
        this._resourceName = resourceName;
    }

    @Override
    public long getPartitionGauge() {
        return this._numOfPartitions;
    }

    @Override
    public long getErrorPartitionGauge() {
        return this._numOfErrorPartitions;
    }

    @Override
    public long getDifferenceWithIdealStateGauge() {
        return this._externalViewIdealStateDiff;
    }

    @Override
    public String getSensorName() {
        return "ResourceStatus_" + this._clusterName + "_" + this._resourceName;
    }

    public void updateExternalView(ExternalView externalView, IdealState idealState) {
        if (externalView == null) {
            LOG.warn((Object)"external view is null");
            return;
        }
        String resourceName = externalView.getId();
        if (idealState == null) {
            LOG.warn((Object)("ideal state is null for " + resourceName));
            this._numOfErrorPartitions = 0;
            this._externalViewIdealStateDiff = 0;
            this._numOfPartitionsInExternalView = 0;
            return;
        }
        assert (resourceName.equals(idealState.getId()));
        int numOfErrorPartitions = 0;
        int numOfDiff = 0;
        if (this._numOfPartitions == 0) {
            this._numOfPartitions = idealState.getRecord().getMapFields().size();
        }
        for (String partitionName : idealState.getRecord().getMapFields().keySet()) {
            Map<String, String> idealRecord = idealState.getInstanceStateMap(partitionName);
            Map<String, String> externalViewRecord = externalView.getStateMap(partitionName);
            if (externalViewRecord == null) {
                numOfDiff += idealRecord.size();
                continue;
            }
            for (String host : idealRecord.keySet()) {
                if (externalViewRecord.containsKey(host) && externalViewRecord.get(host).equals(idealRecord.get(host))) continue;
                ++numOfDiff;
            }
            for (String host : externalViewRecord.keySet()) {
                if (!externalViewRecord.get(host).equalsIgnoreCase(HelixDefinedState.ERROR.toString())) continue;
                ++numOfErrorPartitions;
            }
        }
        this._numOfErrorPartitions = numOfErrorPartitions;
        this._externalViewIdealStateDiff = numOfDiff;
        this._numOfPartitionsInExternalView = externalView.getPartitionSet().size();
    }

    @Override
    public long getExternalViewPartitionGauge() {
        return this._numOfPartitionsInExternalView;
    }

    public String getBeanName() {
        return this._clusterName + " " + this._resourceName;
    }
}

