/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.io.IOException;
import java.io.Reader;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.core.CheckedDroolsException;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseFactory;
import org.drools.core.rule.Package;

public class RuleBaseLoader {
    private static final RuleBaseLoader INSTANCE = new RuleBaseLoader();
    private static int engineType = 1;

    private RuleBaseLoader() {
    }

    public static RuleBaseLoader getInstance() {
        return INSTANCE;
    }

    public RuleBase loadFromReader(Reader drl) throws CheckedDroolsException, IOException {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl(drl);
        return this.makeRuleBase(builder);
    }

    public RuleBase loadFromReader(Reader drl, Reader dsl) throws CheckedDroolsException, IOException {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl(drl, dsl);
        return this.makeRuleBase(builder);
    }

    public void setDefaultEngineType(int type) {
        engineType = type;
    }

    private RuleBase makeRuleBase(PackageBuilder builder) throws CheckedDroolsException {
        if (builder.hasErrors()) {
            throw new CheckedDroolsException("There were errors in the rule source: " + builder.getErrors().toString());
        }
        Package binaryPackage = builder.getPackage();
        RuleBase rb = RuleBaseFactory.newRuleBase((int)engineType);
        try {
            rb.addPackage(binaryPackage);
        }
        catch (Exception e) {
            throw new CheckedDroolsException("Unable to add compiled package to rulebase. Nested error is: " + e.getMessage());
        }
        return rb;
    }
}

