/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.recovery;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.journal.JournalRecord;
import bitronix.tm.recovery.DanglingTransaction;
import bitronix.tm.recovery.RecovererMBean;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.recovery.RecoveryHelper;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.ManagementRegistrar;
import bitronix.tm.utils.Service;
import bitronix.tm.utils.Uid;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recoverer
implements Runnable,
Service,
RecovererMBean {
    private static final Logger log = LoggerFactory.getLogger(Recoverer.class);
    private final Map<String, XAResourceProducer> registeredResources = new HashMap<String, XAResourceProducer>();
    private final Map<String, Set<BitronixXid>> recoveredXidSets = new HashMap<String, Set<BitronixXid>>();
    private volatile Exception completionException;
    private volatile int committedCount;
    private volatile int rolledbackCount;
    private volatile int executionsCount;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final String jmxName;

    public Recoverer() {
        String serverId = TransactionManagerServices.getConfiguration().getServerId();
        if (serverId == null) {
            serverId = "";
        }
        this.jmxName = "bitronix.tm:type=Recoverer,ServerId=" + ManagementRegistrar.makeValidName(serverId);
        ManagementRegistrar.register(this.jmxName, this);
    }

    @Override
    public void shutdown() {
        ManagementRegistrar.unregister(this.jmxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isRunning.compareAndSet(false, true)) {
            log.info("recoverer is already running, abandoning this recovery request");
            return;
        }
        try {
            try {
                this.committedCount = 0;
                this.rolledbackCount = 0;
                long oldestTransactionTimestamp = Long.MAX_VALUE;
                Map<Uid, JournalRecord> danglingRecords = TransactionManagerServices.getJournal().collectDanglingRecords();
                Class<ResourceRegistrar> clazz = ResourceRegistrar.class;
                synchronized (ResourceRegistrar.class) {
                    for (String name : ResourceRegistrar.getResourcesUniqueNames()) {
                        this.registeredResources.put(name, ResourceRegistrar.get(name));
                    }
                    if (TransactionManagerServices.isTransactionManagerRunning()) {
                        oldestTransactionTimestamp = TransactionManagerServices.getTransactionManager().getOldestInFlightTransactionTimestamp();
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    this.recoverAllResources();
                    Set<Uid> committedGtrids = this.commitDanglingTransactions(oldestTransactionTimestamp, danglingRecords);
                    this.committedCount = committedGtrids.size();
                    this.rolledbackCount = this.rollbackAbortedTransactions(oldestTransactionTimestamp, committedGtrids);
                    if (this.executionsCount == 0 || this.committedCount > 0 || this.rolledbackCount > 0) {
                        log.info("recovery committed " + this.committedCount + " dangling transaction(s) and rolled back " + this.rolledbackCount + " aborted transaction(s) on " + this.registeredResources.size() + " resource(s) [" + this.getRegisteredResourcesUniqueNames() + "]" + (TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
                    } else if (log.isDebugEnabled()) {
                        log.debug("recovery committed " + this.committedCount + " dangling transaction(s) and rolled back " + this.rolledbackCount + " aborted transaction(s) on " + this.registeredResources.size() + " resource(s) [" + this.getRegisteredResourcesUniqueNames() + "]" + (TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
                    }
                    this.completionException = null;
                }
            }
            catch (Exception ex) {
                this.completionException = ex;
                log.warn("recovery failed, registered resource(s): " + this.getRegisteredResourcesUniqueNames(), (Throwable)ex);
                Object var9_9 = null;
                this.recoveredXidSets.clear();
                this.registeredResources.clear();
                ++this.executionsCount;
                this.isRunning.set(false);
            }
            {
                Object var9_8 = null;
                this.recoveredXidSets.clear();
                this.registeredResources.clear();
                ++this.executionsCount;
                this.isRunning.set(false);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.recoveredXidSets.clear();
            this.registeredResources.clear();
            ++this.executionsCount;
            this.isRunning.set(false);
            throw throwable;
        }
        {
            return;
        }
    }

    @Override
    public Exception getCompletionException() {
        return this.completionException;
    }

    @Override
    public int getCommittedCount() {
        return this.committedCount;
    }

    @Override
    public int getRolledbackCount() {
        return this.rolledbackCount;
    }

    @Override
    public int getExecutionsCount() {
        return this.executionsCount;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    private void recoverAllResources() {
        for (Map.Entry<String, XAResourceProducer> entry : new HashMap<String, XAResourceProducer>(this.registeredResources).entrySet()) {
            String uniqueName = entry.getKey();
            XAResourceProducer producer = entry.getValue();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("performing recovery on " + uniqueName);
                }
                Set<BitronixXid> xids = this.recover(producer);
                if (log.isDebugEnabled()) {
                    log.debug("recovered " + xids.size() + " XID(s) from resource " + uniqueName);
                }
                this.recoveredXidSets.put(uniqueName, xids);
                producer.setFailed(false);
            }
            catch (XAException ex) {
                producer.setFailed(true);
                this.registeredResources.remove(uniqueName);
                String extraErrorDetails = TransactionManagerServices.getExceptionAnalyzer().extractExtraXAExceptionDetails(ex);
                log.warn("error running recovery on resource '" + uniqueName + "', resource marked as failed (background recoverer will retry recovery)" + " (error=" + Decoder.decodeXAExceptionErrorCode(ex) + ")" + (extraErrorDetails == null ? "" : ", extra error=" + extraErrorDetails), (Throwable)ex);
            }
            catch (Exception ex) {
                producer.setFailed(true);
                this.registeredResources.remove(uniqueName);
                log.warn("error running recovery on resource '" + uniqueName + "', resource marked as failed (background recoverer will retry recovery)", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BitronixXid> recover(XAResourceProducer producer) throws XAException, RecoveryException {
        Set<BitronixXid> set;
        if (producer == null) {
            throw new IllegalArgumentException("recoverable resource cannot be null");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("running recovery on " + producer);
            }
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            set = RecoveryHelper.recover(xaResourceHolderState);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            producer.endRecovery();
            throw throwable;
        }
        producer.endRecovery();
        return set;
    }

    private Set<Uid> commitDanglingTransactions(long oldestTransactionTimestamp, Map<Uid, JournalRecord> danglingRecords) throws IOException, RecoveryException {
        HashSet<Uid> committedGtrids = new HashSet<Uid>();
        if (log.isDebugEnabled()) {
            log.debug("found " + danglingRecords.size() + " dangling record(s) in journal");
        }
        for (Map.Entry<Uid, JournalRecord> entry : danglingRecords.entrySet()) {
            Uid gtrid = entry.getKey();
            JournalRecord tlog = entry.getValue();
            Set<String> uniqueNames = tlog.getUniqueNames();
            Set<DanglingTransaction> danglingTransactions = this.getDanglingTransactionsInRecoveredXids(uniqueNames, tlog.getGtrid());
            long txTimestamp = gtrid.extractTimestamp();
            if (log.isDebugEnabled()) {
                log.debug("recovered XID timestamp: " + txTimestamp + " - oldest in-flight TX timestamp: " + oldestTransactionTimestamp);
            }
            if (txTimestamp < oldestTransactionTimestamp) {
                if (log.isDebugEnabled()) {
                    log.debug("committing dangling transaction with GTRID " + gtrid);
                }
                this.commit(danglingTransactions);
                if (log.isDebugEnabled()) {
                    log.debug("committed dangling transaction with GTRID " + gtrid);
                }
                committedGtrids.add(gtrid);
                Set<String> participatingUniqueNames = this.filterParticipatingUniqueNamesInRecoveredXids(uniqueNames);
                if (participatingUniqueNames.size() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("updating journal's transaction with GTRID " + gtrid + " status to COMMITTED for names [" + Recoverer.buildUniqueNamesString(participatingUniqueNames) + "]");
                    }
                    TransactionManagerServices.getJournal().log(3, tlog.getGtrid(), participatingUniqueNames);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("not updating journal's transaction with GTRID " + gtrid + " status to COMMITTED as no resource could be found (incremental recovery will need to clean this)");
                }
                committedGtrids.remove(gtrid);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("skipping in-flight transaction with GTRID " + gtrid);
        }
        if (log.isDebugEnabled()) {
            log.debug("committed " + committedGtrids.size() + " dangling transaction(s)");
        }
        return committedGtrids;
    }

    private Set<DanglingTransaction> getDanglingTransactionsInRecoveredXids(Set<String> uniqueNames, Uid gtrid) {
        HashSet<DanglingTransaction> danglingTransactions = new HashSet<DanglingTransaction>();
        for (String uniqueName : uniqueNames) {
            Set<BitronixXid> recoveredXids;
            if (log.isDebugEnabled()) {
                log.debug("finding dangling transaction(s) in recovered XID(s) of resource " + uniqueName);
            }
            if ((recoveredXids = this.recoveredXidSets.get(uniqueName)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("resource " + uniqueName + " did not recover, skipping commit");
                continue;
            }
            for (BitronixXid recoveredXid : recoveredXids) {
                if (!gtrid.equals(recoveredXid.getGlobalTransactionIdUid())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("found a recovered XID matching dangling log's GTRID " + gtrid + " in resource " + uniqueName);
                }
                danglingTransactions.add(new DanglingTransaction(uniqueName, recoveredXid));
            }
        }
        return danglingTransactions;
    }

    private Set<String> filterParticipatingUniqueNamesInRecoveredXids(Set<String> uniqueNames) {
        HashSet<String> recoveredUniqueNames = new HashSet<String>();
        for (String uniqueName : uniqueNames) {
            Set<BitronixXid> recoveredXids;
            if (log.isDebugEnabled()) {
                log.debug("finding dangling transaction(s) in recovered XID(s) of resource " + uniqueName);
            }
            if ((recoveredXids = this.recoveredXidSets.get(uniqueName)) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("cannot find resource '" + uniqueName + "' present in the journal, leaving it for incremental recovery");
                continue;
            }
            recoveredUniqueNames.add(uniqueName);
        }
        return recoveredUniqueNames;
    }

    private void commit(Set<DanglingTransaction> danglingTransactions) throws RecoveryException {
        if (log.isDebugEnabled()) {
            log.debug(danglingTransactions.size() + " branch(es) to commit");
        }
        for (DanglingTransaction danglingTransaction : danglingTransactions) {
            Xid xid = danglingTransaction.getXid();
            String uniqueName = danglingTransaction.getUniqueName();
            if (log.isDebugEnabled()) {
                log.debug("committing branch with XID " + xid + " on " + uniqueName);
            }
            this.commit(uniqueName, xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commit(String uniqueName, Xid xid) throws RecoveryException {
        boolean bl;
        XAResourceProducer producer = this.registeredResources.get(uniqueName);
        try {
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            bl = RecoveryHelper.commit(xaResourceHolderState, xid);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            producer.endRecovery();
            throw throwable;
        }
        producer.endRecovery();
        return bl;
    }

    private int rollbackAbortedTransactions(long oldestTransactionTimestamp, Set<Uid> committedGtrids) throws RecoveryException {
        if (log.isDebugEnabled()) {
            log.debug("rolling back aborted branch(es)");
        }
        int rollbackCount = 0;
        for (Map.Entry<String, Set<BitronixXid>> entry : this.recoveredXidSets.entrySet()) {
            String uniqueName = entry.getKey();
            Set<BitronixXid> recoveredXids = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug("checking " + recoveredXids.size() + " branch(es) on " + uniqueName + " for rollback");
            }
            int count = this.rollbackAbortedBranchesOfResource(oldestTransactionTimestamp, uniqueName, recoveredXids, committedGtrids);
            if (log.isDebugEnabled()) {
                log.debug("checked " + recoveredXids.size() + " branch(es) on " + uniqueName + " for rollback");
            }
            rollbackCount += count;
        }
        if (log.isDebugEnabled()) {
            log.debug("rolled back " + rollbackCount + " aborted branch(es)");
        }
        return rollbackCount;
    }

    private int rollbackAbortedBranchesOfResource(long oldestTransactionTimestamp, String uniqueName, Set<BitronixXid> recoveredXids, Set<Uid> committedGtrids) throws RecoveryException {
        int abortedCount = 0;
        for (BitronixXid recoveredXid : recoveredXids) {
            boolean success;
            if (committedGtrids.contains(recoveredXid.getGlobalTransactionIdUid())) {
                if (!log.isDebugEnabled()) continue;
                log.debug("XID has been committed, skipping rollback: " + recoveredXid + " on " + uniqueName);
                continue;
            }
            long txTimestamp = recoveredXid.getGlobalTransactionIdUid().extractTimestamp();
            if (log.isDebugEnabled()) {
                log.debug("recovered XID timestamp: " + txTimestamp + " - oldest in-flight TX timestamp: " + oldestTransactionTimestamp);
            }
            if (txTimestamp >= oldestTransactionTimestamp) {
                if (!log.isDebugEnabled()) continue;
                log.debug("skipping XID of in-flight transaction: " + recoveredXid);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("rolling back in-doubt branch with XID " + recoveredXid + " on " + uniqueName);
            }
            if (!(success = this.rollback(uniqueName, recoveredXid))) continue;
            ++abortedCount;
        }
        return abortedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rollback(String uniqueName, Xid xid) throws RecoveryException {
        boolean bl;
        XAResourceProducer producer = this.registeredResources.get(uniqueName);
        if (producer == null) {
            if (log.isDebugEnabled()) {
                log.debug("resource " + uniqueName + " has not recovered, skipping rollback");
            }
            return false;
        }
        try {
            XAResourceHolderState xaResourceHolderState = producer.startRecovery();
            bl = RecoveryHelper.rollback(xaResourceHolderState, xid);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            producer.endRecovery();
            throw throwable;
        }
        producer.endRecovery();
        return bl;
    }

    private String getRegisteredResourcesUniqueNames() {
        return Recoverer.buildUniqueNamesString(this.registeredResources.keySet());
    }

    private static String buildUniqueNamesString(Set<String> uniqueNames) {
        StringBuilder resourcesUniqueNames = new StringBuilder();
        Iterator<String> it = uniqueNames.iterator();
        while (it.hasNext()) {
            String uniqueName = it.next();
            resourcesUniqueNames.append(uniqueName);
            if (!it.hasNext()) continue;
            resourcesUniqueNames.append(", ");
        }
        return resourcesUniqueNames.toString();
    }
}

