/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet;

import com.noelios.restlet.component.ChildContext;
import com.noelios.restlet.util.IdentClient;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.service.LogService;
import org.restlet.util.Template;

public class LogFilter
extends Filter {
    protected volatile LogService logService;
    protected volatile Template logTemplate;
    private volatile Logger logLogger;

    public LogFilter(Context context, LogService logService) {
        super(context);
        this.logService = logService;
        if (logService != null) {
            this.logTemplate = logService.getLogFormat() == null ? null : new Template(logService.getLogFormat());
            this.logLogger = logService.getLoggerName() != null ? Logger.getLogger(logService.getLoggerName()) : Logger.getLogger(context.getLogger().getParent().getName() + "." + ChildContext.getBestClassName(logService.getClass()));
        }
    }

    protected void afterHandle(Request request, Response response) {
        if (this.logTemplate != null) {
            this.logLogger.log(Level.INFO, this.format(request, response));
        } else if (this.logLogger.isLoggable(Level.INFO)) {
            long startTime = (Long)request.getAttributes().get("org.restlet.startTime");
            int duration = (int)(System.currentTimeMillis() - startTime);
            this.logLogger.log(Level.INFO, this.formatDefault(request, response, duration));
        }
    }

    protected int beforeHandle(Request request, Response response) {
        request.getAttributes().put("org.restlet.startTime", System.currentTimeMillis());
        return 0;
    }

    protected String format(Request request, Response response) {
        return this.logTemplate.format(request, response);
    }

    protected String formatDefault(Request request, Response response, int duration) {
        StringBuilder sb = new StringBuilder();
        long currentTime = System.currentTimeMillis();
        sb.append(String.format("%tF", currentTime));
        sb.append('\t');
        sb.append(String.format("%tT", currentTime));
        sb.append('\t');
        String clientAddress = request.getClientInfo().getAddress();
        sb.append(clientAddress == null ? "-" : clientAddress);
        sb.append('\t');
        if (this.logService.isIdentityCheck()) {
            IdentClient ic = new IdentClient(request.getClientInfo().getAddress(), request.getClientInfo().getPort(), response.getServerInfo().getPort());
            sb.append(ic.getUserIdentifier() == null ? "-" : ic.getUserIdentifier());
        } else {
            sb.append('-');
        }
        sb.append('\t');
        String serverAddress = response.getServerInfo().getAddress();
        sb.append(serverAddress == null ? "-" : serverAddress);
        sb.append('\t');
        Integer serverport = response.getServerInfo().getPort();
        sb.append(serverport == null ? "-" : serverport.toString());
        sb.append('\t');
        String methodName = request.getMethod() == null ? "-" : request.getMethod().getName();
        sb.append(methodName == null ? "-" : methodName);
        sb.append('\t');
        String resourcePath = request.getResourceRef() == null ? "-" : request.getResourceRef().getPath();
        sb.append(resourcePath == null ? "-" : resourcePath);
        sb.append('\t');
        String resourceQuery = request.getResourceRef() == null ? "-" : request.getResourceRef().getQuery();
        sb.append(resourceQuery == null ? "-" : resourceQuery);
        sb.append('\t');
        sb.append(response.getStatus() == null ? "-" : Integer.toString(response.getStatus().getCode()));
        sb.append('\t');
        if (response.getEntity() == null) {
            sb.append('0');
        } else {
            sb.append(response.getEntity().getSize() == -1L ? "-" : Long.toString(response.getEntity().getSize()));
        }
        sb.append('\t');
        if (request.getEntity() == null) {
            sb.append('0');
        } else {
            sb.append(request.getEntity().getSize() == -1L ? "-" : Long.toString(request.getEntity().getSize()));
        }
        sb.append('\t');
        sb.append(duration);
        sb.append('\t');
        sb.append(request.getHostRef() == null ? "-" : request.getHostRef().toString());
        sb.append('\t');
        String agentName = request.getClientInfo().getAgent();
        sb.append(agentName == null ? "-" : agentName);
        sb.append('\t');
        sb.append(request.getReferrerRef() == null ? "-" : request.getReferrerRef().getIdentifier());
        return sb.toString();
    }
}

