/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmJTATransactionManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.kie.internal.executor.api.ErrorInfo;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.RequestInfo;
import org.kie.internal.executor.api.STATUS;

public class ExecutorQueryServiceImpl
implements ExecutorQueryService {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    @PostConstruct
    public void init() {
        if (!((JbpmServicesPersistenceManagerImpl)this.pm).hasTransactionManager()) {
            ((JbpmServicesPersistenceManagerImpl)this.pm).setTransactionManager((JbpmServicesTransactionManager)new JbpmJTATransactionManager());
        }
    }

    public List<RequestInfo> getPendingRequests() {
        return (List)this.pm.queryWithParametersInTransaction("PendingRequests", (Map)this.pm.addParametersToMap(new Object[]{"now", new Date()}));
    }

    public List<RequestInfo> getPendingRequestById(Long id) {
        return (List)this.pm.queryWithParametersInTransaction("PendingRequestById", (Map)this.pm.addParametersToMap(new Object[]{"id", id}));
    }

    public RequestInfo getRequestById(Long id) {
        return (RequestInfo)this.pm.find(org.jbpm.executor.entities.RequestInfo.class, (Object)id);
    }

    public List<RequestInfo> getRunningRequests() {
        return (List)this.pm.queryInTransaction("RunningRequests");
    }

    public List<RequestInfo> getQueuedRequests() {
        return (List)this.pm.queryInTransaction("QueuedRequests");
    }

    public List<RequestInfo> getFutureQueuedRequests() {
        return (List)this.pm.queryWithParametersInTransaction("FutureQueuedRequests", (Map)this.pm.addParametersToMap(new Object[]{"now", new Date()}));
    }

    public List<RequestInfo> getCompletedRequests() {
        return (List)this.pm.queryInTransaction("CompletedRequests");
    }

    public List<RequestInfo> getInErrorRequests() {
        return (List)this.pm.queryInTransaction("InErrorRequests");
    }

    public List<RequestInfo> getCancelledRequests() {
        return (List)this.pm.queryInTransaction("CancelledRequests");
    }

    public List<ErrorInfo> getAllErrors() {
        return (List)this.pm.queryInTransaction("GetAllErrors");
    }

    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        return (List)this.pm.queryWithParametersInTransaction("GetErrorsByRequestId", (Map)this.pm.addParametersToMap(new Object[]{"id", requestId}));
    }

    public List<RequestInfo> getAllRequests() {
        return (List)this.pm.queryInTransaction("GetAllRequests");
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        return (List)this.pm.queryWithParametersInTransaction("GetRequestsByStatus", (Map)this.pm.addParametersToMap(new Object[]{"statuses", statuses}));
    }

    public List<RequestInfo> getRequestByBusinessKey(String businessKey) {
        return (List)this.pm.queryWithParametersInTransaction("GetRequestsByBusinessKey", (Map)this.pm.addParametersToMap(new Object[]{"businessKey", businessKey}));
    }

    public RequestInfo getRequestForProcessing() {
        RequestInfo request = null;
        boolean txOwner = this.pm.beginTransaction();
        try {
            request = (RequestInfo)this.pm.queryAndLockWithParametersInTransaction("PendingRequests", (Map)this.pm.addParametersToMap(new Object[]{"now", new Date(), "firstResult", 0, "maxResults", 1}), true);
            if (request != null) {
                request.setStatus(STATUS.RUNNING);
                this.pm.merge((Object)request);
            }
            this.pm.endTransaction(txOwner);
        }
        catch (NoResultException e) {
            this.pm.endTransaction(txOwner);
        }
        catch (Exception e) {
            this.pm.rollBackTransaction(txOwner);
        }
        return request;
    }
}

