/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.factory.CDITaskServiceFactory;
import org.jbpm.runtime.manager.impl.tx.DestroySessionTransactionSynchronization;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.task.api.InternalTaskService;

public class PerRequestRuntimeManager
extends AbstractRuntimeManager {
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<RuntimeEngine> local = new ThreadLocal();

    public PerRequestRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        activeManagers.add(identifier);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        if (local.get() != null) {
            return local.get();
        }
        InternalTaskService internalTaskService = (InternalTaskService)this.taskServiceFactory.newTaskService();
        this.configureRuntimeOnTaskService(internalTaskService);
        RuntimeEngineImpl runtime = new RuntimeEngineImpl(this.factory.newKieSession(), (TaskService)internalTaskService);
        runtime.setManager((RuntimeManager)this);
        this.registerDisposeCallback(runtime, new DisposeSessionTransactionSynchronization((RuntimeManager)this, runtime));
        this.registerDisposeCallback(runtime, new DestroySessionTransactionSynchronization(runtime.getKieSession()));
        this.registerItems(runtime);
        this.attachManager(runtime);
        local.set(runtime);
        return runtime;
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        RuntimeEngine runtimeInUse = local.get();
        if (runtimeInUse == null || runtimeInUse.getKieSession().getId() != ksession.getId()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        block5: {
            local.set(null);
            try {
                if (this.canDestroy()) {
                    runtime.getKieSession().destroy();
                } else if (runtime instanceof Disposable) {
                    ((Disposable)runtime).dispose();
                }
            }
            catch (Exception e) {
                if (!(runtime instanceof Disposable)) break block5;
                ((Disposable)runtime).dispose();
            }
        }
    }

    @Override
    public void close() {
        try {
            if (this.taskServiceFactory instanceof CDITaskServiceFactory) {
                this.removeRuntimeFromTaskService((InternalTaskService)this.taskServiceFactory.newTaskService());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this.factory.close();
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }

    @Override
    public void init() {
        this.configureRuntimeOnTaskService((InternalTaskService)this.taskServiceFactory.newTaskService());
    }
}

