/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.runtime.manager.RuntimeManager;

public class RuntimeManagerRegistry {
    private Map<String, RuntimeManager> registry = new ConcurrentHashMap<String, RuntimeManager>();
    private static RuntimeManagerRegistry instance;

    protected RuntimeManagerRegistry() {
    }

    public static RuntimeManagerRegistry get() {
        if (instance == null) {
            instance = new RuntimeManagerRegistry();
        }
        return instance;
    }

    public void addRuntimeManager(String id, RuntimeManager manager) {
        if (this.registry.containsKey(id)) {
            throw new IllegalStateException("RuntimeManager with id " + id + " is already registered");
        }
        this.registry.put(id, manager);
    }

    public void remove(String id) {
        this.registry.remove(id);
    }

    public RuntimeManager getRuntimeManager(String id) {
        return this.registry.get(id);
    }
}

