/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.DynamicRouter;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Pattern;
import org.apache.camel.Processor;
import org.apache.camel.RecipientList;
import org.apache.camel.RoutingSlip;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.bean.BeanHelper;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.component.bean.ParameterInfo;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInfo {
    private static final transient Logger LOG = LoggerFactory.getLogger(MethodInfo.class);
    private CamelContext camelContext;
    private Class<?> type;
    private Method method;
    private final List<ParameterInfo> parameters;
    private final List<ParameterInfo> bodyParameters;
    private final boolean hasCustomAnnotation;
    private final boolean hasHandlerAnnotation;
    private Expression parametersExpression;
    private ExchangePattern pattern = ExchangePattern.InOut;
    private org.apache.camel.processor.RecipientList recipientList;
    private org.apache.camel.processor.RoutingSlip routingSlip;
    private org.apache.camel.processor.DynamicRouter dynamicRouter;

    public MethodInfo(CamelContext camelContext, Class<?> type, Method method, List<ParameterInfo> parameters, List<ParameterInfo> bodyParameters, boolean hasCustomAnnotation, boolean hasHandlerAnnotation) {
        Annotation annotation;
        this.camelContext = camelContext;
        this.type = type;
        this.method = method;
        this.parameters = parameters;
        this.bodyParameters = bodyParameters;
        this.hasCustomAnnotation = hasCustomAnnotation;
        this.hasHandlerAnnotation = hasHandlerAnnotation;
        this.parametersExpression = this.createParametersExpression();
        Pattern oneway = this.findOneWayAnnotation(method);
        if (oneway != null) {
            this.pattern = oneway.value();
        }
        if (method.getAnnotation(RoutingSlip.class) != null && this.matchContext(method.getAnnotation(RoutingSlip.class).context())) {
            annotation = method.getAnnotation(RoutingSlip.class);
            this.routingSlip = new org.apache.camel.processor.RoutingSlip(camelContext);
            this.routingSlip.setDelimiter(annotation.delimiter());
            this.routingSlip.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
            try {
                camelContext.addService(this.routingSlip);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (method.getAnnotation(DynamicRouter.class) != null && this.matchContext(method.getAnnotation(DynamicRouter.class).context())) {
            annotation = method.getAnnotation(DynamicRouter.class);
            this.dynamicRouter = new org.apache.camel.processor.DynamicRouter(camelContext);
            this.dynamicRouter.setDelimiter(annotation.delimiter());
            this.dynamicRouter.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
            try {
                camelContext.addService(this.dynamicRouter);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (method.getAnnotation(RecipientList.class) != null && this.matchContext(method.getAnnotation(RecipientList.class).context())) {
            ExecutorService executor;
            annotation = method.getAnnotation(RecipientList.class);
            this.recipientList = new org.apache.camel.processor.RecipientList(camelContext, annotation.delimiter());
            this.recipientList.setStopOnException(annotation.stopOnException());
            this.recipientList.setIgnoreInvalidEndpoints(annotation.ignoreInvalidEndpoints());
            this.recipientList.setParallelProcessing(annotation.parallelProcessing());
            this.recipientList.setStreaming(annotation.streaming());
            this.recipientList.setTimeout(annotation.timeout());
            this.recipientList.setShareUnitOfWork(annotation.shareUnitOfWork());
            if (ObjectHelper.isNotEmpty(annotation.executorServiceRef())) {
                executor = camelContext.getExecutorServiceManager().newDefaultThreadPool(this, annotation.executorServiceRef());
                this.recipientList.setExecutorService(executor);
            }
            if (annotation.parallelProcessing() && this.recipientList.getExecutorService() == null) {
                executor = camelContext.getExecutorServiceManager().newDefaultThreadPool(this, "@RecipientList");
                this.recipientList.setExecutorService(executor);
            }
            if (ObjectHelper.isNotEmpty(annotation.strategyRef())) {
                AggregationStrategy strategy = CamelContextHelper.mandatoryLookup(camelContext, annotation.strategyRef(), AggregationStrategy.class);
                this.recipientList.setAggregationStrategy(strategy);
            }
            if (ObjectHelper.isNotEmpty(annotation.onPrepareRef())) {
                Processor onPrepare = CamelContextHelper.mandatoryLookup(camelContext, annotation.onPrepareRef(), Processor.class);
                this.recipientList.setOnPrepare(onPrepare);
            }
            try {
                camelContext.addService(this.recipientList);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
    }

    private boolean matchContext(String context) {
        return !ObjectHelper.isNotEmpty(context) || this.camelContext.getName().equals(context);
    }

    public String toString() {
        return this.method.toString();
    }

    public MethodInvocation createMethodInvocation(final Object pojo, final Exchange exchange) {
        final Object[] arguments = this.parametersExpression.evaluate(exchange, Object[].class);
        return new MethodInvocation(){

            @Override
            public Method getMethod() {
                return MethodInfo.this.method;
            }

            @Override
            public Object[] getArguments() {
                return arguments;
            }

            @Override
            public Object proceed(AsyncCallback callback, AtomicBoolean doneSync) throws Exception {
                if (MethodInfo.this.dynamicRouter != null) {
                    if (!MethodInfo.this.dynamicRouter.isStarted()) {
                        ServiceHelper.startService(MethodInfo.this.dynamicRouter);
                    }
                    DynamicRouterExpression expression = new DynamicRouterExpression(pojo);
                    boolean sync = MethodInfo.this.dynamicRouter.doRoutingSlip(exchange, expression, callback);
                    doneSync.set(sync);
                    return Void.TYPE;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace(">>>> invoking: {} on bean: {} with arguments: {} for exchange: {}", new Object[]{MethodInfo.this.method, pojo, ObjectHelper.asString(arguments), exchange});
                }
                Object result = MethodInfo.this.invoke(MethodInfo.this.method, pojo, arguments, exchange);
                if (MethodInfo.this.recipientList != null) {
                    if (!MethodInfo.this.recipientList.isStarted()) {
                        ServiceHelper.startService(MethodInfo.this.recipientList);
                    }
                    boolean sync = MethodInfo.this.recipientList.sendToRecipientList(exchange, result, callback);
                    doneSync.set(sync);
                    return Void.TYPE;
                }
                if (MethodInfo.this.routingSlip != null) {
                    if (!MethodInfo.this.routingSlip.isStarted()) {
                        ServiceHelper.startService(MethodInfo.this.routingSlip);
                    }
                    boolean sync = MethodInfo.this.routingSlip.doRoutingSlip(exchange, result, callback);
                    doneSync.set(sync);
                    return Void.TYPE;
                }
                return result;
            }

            @Override
            public Object getThis() {
                return pojo;
            }

            @Override
            public AccessibleObject getStaticPart() {
                return MethodInfo.this.method;
            }
        };
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public Expression getParametersExpression() {
        return this.parametersExpression;
    }

    public List<ParameterInfo> getBodyParameters() {
        return this.bodyParameters;
    }

    public Class<?> getBodyParameterType() {
        if (this.bodyParameters.isEmpty()) {
            return null;
        }
        ParameterInfo parameterInfo = this.bodyParameters.get(0);
        return parameterInfo.getType();
    }

    public boolean bodyParameterMatches(Class<?> bodyType) {
        Class<?> actualType = this.getBodyParameterType();
        return actualType != null && ObjectHelper.isAssignableFrom(bodyType, actualType);
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public boolean hasBodyParameter() {
        return !this.bodyParameters.isEmpty();
    }

    public boolean hasCustomAnnotation() {
        return this.hasCustomAnnotation;
    }

    public boolean hasHandlerAnnotation() {
        return this.hasHandlerAnnotation;
    }

    public boolean isReturnTypeVoid() {
        return this.method.getReturnType().getName().equals("void");
    }

    public boolean isStaticMethod() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    protected Object invoke(Method mth, Object pojo, Object[] arguments, Exchange exchange) throws InvocationTargetException {
        try {
            return mth.invoke(pojo, arguments);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExchangeException("IllegalAccessException occurred invoking method: " + mth + " using arguments: " + Arrays.asList(arguments), exchange, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeExchangeException("IllegalArgumentException occurred invoking method: " + mth + " using arguments: " + Arrays.asList(arguments), exchange, e);
        }
    }

    protected Expression createParametersExpression() {
        final int size = this.parameters.size();
        LOG.trace("Creating parameters expression for {} parameters", (Object)size);
        final Expression[] expressions = new Expression[size];
        for (int i = 0; i < size; ++i) {
            Expression parameterExpression;
            expressions[i] = parameterExpression = this.parameters.get(i).getExpression();
            LOG.trace("Parameter #{} has expression: {}", (Object)i, (Object)parameterExpression);
        }
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Object[] answer = new Object[size];
                Object body = exchange.getIn().getBody();
                boolean multiParameterArray = false;
                if (exchange.getIn().getHeader("CamelBeanMultiParameterArray") != null) {
                    multiParameterArray = exchange.getIn().getHeader("CamelBeanMultiParameterArray", Boolean.class);
                }
                String methodName = exchange.getIn().getHeader("CamelBeanMethodName", "", String.class);
                String methodParameters = ObjectHelper.between(methodName, "(", ")");
                Iterator<Object> it = null;
                if (methodParameters != null) {
                    it = ObjectHelper.createIterator(methodParameters);
                }
                exchange.getIn().removeHeader("CamelBeanMultiParameterArray");
                exchange.getIn().removeHeader("CamelBeanMethodName");
                for (int i = 0; i < size; ++i) {
                    Object parameterValue = it != null && it.hasNext() ? it.next() : null;
                    Class<?> parameterType = ((ParameterInfo)MethodInfo.this.parameters.get(i)).getType();
                    Object value = null;
                    if (multiParameterArray) {
                        value = ((Object[])body)[i];
                    } else {
                        if (parameterValue != null && !parameterValue.equals("*")) {
                            value = this.evaluateParameterValue(exchange, i, parameterValue, parameterType);
                        }
                        Expression expression = expressions[i];
                        if (value == null && expression != null) {
                            value = this.evaluateParameterBinding(exchange, expression, i, parameterType);
                        }
                    }
                    if (value == Void.TYPE) continue;
                    answer[i] = value;
                }
                return (T)answer;
            }

            private Object evaluateParameterValue(Exchange exchange, int index, Object parameterValue, Class<?> parameterType) {
                Object answer = null;
                String exp = exchange.getContext().getTypeConverter().convertTo(String.class, parameterValue);
                if (exp != null) {
                    Boolean isClass;
                    boolean valid = BeanHelper.isValidParameterValue(exp = exp.trim());
                    if (!valid && (isClass = BeanHelper.isAssignableToExpectedType(exchange.getContext().getClassResolver(), exp, parameterType)) != null) {
                        return null;
                    }
                    Expression expression = null;
                    try {
                        expression = exchange.getContext().resolveLanguage("simple").createExpression(exp);
                        parameterValue = expression.evaluate(exchange, Object.class);
                    }
                    catch (Exception e) {
                        throw new ExpressionEvaluationException(expression, "Cannot create/evaluate simple expression: " + exp + " to be bound to parameter at index: " + index + " on method: " + MethodInfo.this.getMethod(), exchange, e);
                    }
                    if (parameterValue != null) {
                        if ("null".equals(parameterValue)) {
                            return Void.TYPE;
                        }
                        exp = exchange.getContext().getTypeConverter().convertTo(String.class, parameterValue);
                        if (!valid) {
                            boolean bl = valid = parameterValue instanceof String || BeanHelper.isValidParameterValue(exp);
                        }
                        if (valid) {
                            if (parameterValue instanceof String) {
                                parameterValue = StringHelper.removeLeadingAndEndingQuotes((String)parameterValue);
                            }
                            try {
                                answer = exchange.getContext().getTypeConverter().mandatoryConvertTo(parameterType, parameterValue);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Parameter #{} evaluated as: {} type: ", new Object[]{index, answer, ObjectHelper.type(answer)});
                                }
                            }
                            catch (NoTypeConversionAvailableException e) {
                                throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                            }
                        }
                    }
                }
                return answer;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private Object evaluateParameterBinding(Exchange exchange, Expression expression, int index, Class<?> parameterType) {
                Object answer = null;
                Object result = expression.evaluate(exchange, Object.class);
                if (result != null) {
                    try {
                        answer = exchange.getContext().getTypeConverter().mandatoryConvertTo(parameterType, result);
                        if (!LOG.isTraceEnabled()) return answer;
                        LOG.trace("Parameter #{} evaluated as: {} type: ", new Object[]{index, answer, ObjectHelper.type(answer)});
                        return answer;
                    }
                    catch (NoTypeConversionAvailableException e) {
                        throw ObjectHelper.wrapCamelExecutionException(exchange, e);
                    }
                } else {
                    LOG.trace("Parameter #{} evaluated as null", (Object)index);
                }
                return answer;
            }

            public String toString() {
                return "ParametersExpression: " + Arrays.asList(expressions);
            }
        };
    }

    protected Pattern findOneWayAnnotation(Method method) {
        Pattern answer = this.getPatternAnnotation(method);
        if (answer == null) {
            Class<?>[] interfaces;
            Class<?> type = method.getDeclaringClass();
            ArrayList typesToSearch = new ArrayList();
            this.addTypeAndSuperTypes(type, typesToSearch);
            for (Class<?> anInterface : interfaces = type.getInterfaces()) {
                this.addTypeAndSuperTypes(anInterface, typesToSearch);
            }
            answer = this.findOneWayAnnotationOnMethod(typesToSearch, method);
            if (answer == null) {
                answer = this.findOneWayAnnotation(typesToSearch);
            }
        }
        return answer;
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement) {
        return this.getPatternAnnotation(annotatedElement, 2);
    }

    protected Pattern getPatternAnnotation(AnnotatedElement annotatedElement, int depth) {
        Pattern answer = annotatedElement.getAnnotation(Pattern.class);
        int nextDepth = depth - 1;
        if (nextDepth > 0) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotation instanceof Pattern || annotationType.equals(annotatedElement)) continue;
                Pattern another = this.getPatternAnnotation(annotationType, nextDepth);
                if (this.pattern == null) continue;
                if (answer == null) {
                    answer = another;
                    continue;
                }
                LOG.warn("Duplicate pattern annotation: " + another + " found on annotation: " + annotation + " which will be ignored");
            }
        }
        return answer;
    }

    protected void addTypeAndSuperTypes(Class<?> type, List<Class<?>> result) {
        for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
            result.add(t);
        }
    }

    protected Pattern findOneWayAnnotationOnMethod(List<Class<?>> classes, Method method) {
        for (Class<?> type : classes) {
            try {
                Method definedMethod = type.getMethod(method.getName(), method.getParameterTypes());
                Pattern answer = this.getPatternAnnotation(definedMethod);
                if (answer == null) continue;
                return answer;
            }
            catch (NoSuchMethodException e) {
            }
        }
        return null;
    }

    protected Pattern findOneWayAnnotation(List<Class<?>> classes) {
        for (Class<?> type : classes) {
            Pattern answer = this.getPatternAnnotation(type);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    protected boolean hasExceptionParameter() {
        for (ParameterInfo parameter : this.parameters) {
            if (!Exception.class.isAssignableFrom(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    private final class DynamicRouterExpression
    extends ExpressionAdapter {
        private final Object pojo;

        private DynamicRouterExpression(Object pojo) {
            this.pojo = pojo;
        }

        @Override
        public Object evaluate(Exchange exchange) {
            Object[] arguments = MethodInfo.this.parametersExpression.evaluate(exchange, Object[].class);
            try {
                return MethodInfo.this.invoke(MethodInfo.this.method, this.pojo, arguments, exchange);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }

        public String toString() {
            return "DynamicRouter[invoking: " + MethodInfo.this.method + " on bean: " + this.pojo + "]";
        }
    }
}

