/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;

public abstract class TypeConverterSupport
implements TypeConverter {
    @Override
    public <T> T convertTo(Class<T> type, Object value) throws TypeConversionException {
        return this.convertTo(type, null, value);
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        T t = this.convertTo(type, null, value);
        if (t == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return t;
    }

    @Override
    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        T t = this.convertTo(type, exchange, value);
        if (t == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return t;
    }

    @Override
    public <T> T tryConvertTo(Class<T> type, Object value) {
        try {
            return this.convertTo(type, null, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T> T tryConvertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            return this.convertTo(type, exchange, value);
        }
        catch (Exception e) {
            return null;
        }
    }
}

