/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.deadlines.DeadlinesDecorator;
import org.jbpm.services.task.identity.MvelUserGroupCallbackImpl;
import org.jbpm.services.task.identity.UserGroupLifeCycleManagerDecorator;
import org.jbpm.services.task.identity.UserGroupTaskInstanceServiceDecorator;
import org.jbpm.services.task.identity.UserGroupTaskQueryServiceDecorator;
import org.jbpm.services.task.impl.TaskAdminServiceImpl;
import org.jbpm.services.task.impl.TaskContentServiceImpl;
import org.jbpm.services.task.impl.TaskDeadlinesServiceImpl;
import org.jbpm.services.task.impl.TaskIdentityServiceImpl;
import org.jbpm.services.task.impl.TaskInstanceServiceImpl;
import org.jbpm.services.task.impl.TaskQueryServiceImpl;
import org.jbpm.services.task.impl.TaskServiceEntryPointImpl;
import org.jbpm.services.task.internals.lifecycle.LifeCycleManager;
import org.jbpm.services.task.internals.lifecycle.MVELLifeCycleManager;
import org.jbpm.services.task.rule.impl.RuleContextProviderImpl;
import org.jbpm.services.task.rule.impl.TaskRuleServiceImpl;
import org.jbpm.services.task.subtask.SubTaskDecorator;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmLocalTransactionManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.TaskAdminService;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskIdentityService;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskQueryService;
import org.kie.internal.task.api.UserGroupCallback;

public class HumanTaskServiceFactory {
    private static TaskService service;
    private static EntityManagerFactory emf;
    private static JbpmServicesTransactionManager jbpmTransactionManager;
    private static JbpmServicesPersistenceManager pm;
    private static TaskQueryService queryService;
    private static TaskIdentityService identityService;
    private static TaskAdminService adminService;
    private static TaskContentService contentService;
    private static TaskDeadlinesService deadlinesService;
    private static TaskInstanceService instanceService;
    private static LifeCycleManager lifeCycleManager;
    private static UserGroupLifeCycleManagerDecorator userGroupLifeCycleDecorator;

    public static TaskService newTaskService() {
        HumanTaskServiceFactory.configure();
        return service;
    }

    public static HumanTaskConfigurator newTaskServiceConfigurator() {
        return new HumanTaskConfigurator();
    }

    public static JbpmServicesPersistenceManager getJbpmServicesPersistenceManager() {
        return pm;
    }

    public static void configure() {
        service = new TaskServiceEntryPointImpl();
        HumanTaskServiceFactory.configurePersistenceManager();
        UserGroupCallback userGroupCallback = HumanTaskServiceFactory.createUserGroupCallback();
        HumanTaskServiceFactory.configureTaskQueryService(pm);
        TaskQueryService userGroupQueryServiceDecorator = HumanTaskServiceFactory.configureUserGroupQueryServiceDecorator(queryService, userGroupCallback);
        ((TaskServiceEntryPointImpl)service).setTaskQueryService(userGroupQueryServiceDecorator);
        HumanTaskServiceFactory.configureTaskIdentityService(pm);
        ((TaskServiceEntryPointImpl)service).setTaskIdentityService(identityService);
        HumanTaskServiceFactory.configureTaskAdminService(pm);
        ((TaskServiceEntryPointImpl)service).setTaskAdminService(adminService);
        HumanTaskServiceFactory.configureTaskContentService(pm);
        ((TaskServiceEntryPointImpl)service).setTaskContentService(contentService);
        HumanTaskServiceFactory.configureTaskDeadlinesService(pm);
        HumanTaskServiceFactory.configureTaskInstanceService(pm, queryService);
        HumanTaskServiceFactory.configureLifeCycleManager(pm, identityService, queryService, contentService);
        HumanTaskServiceFactory.configureUserGroupLifeCycleManagerDecorator(pm, lifeCycleManager, userGroupCallback);
        ((TaskInstanceServiceImpl)instanceService).setLifeCycleManager(userGroupLifeCycleDecorator);
        TaskInstanceService userGroupTaskInstanceServiceDecorator = HumanTaskServiceFactory.configureUserGroupTaskInstanceServiceDecorator(instanceService, userGroupCallback);
        SubTaskDecorator subTaskDecorator = HumanTaskServiceFactory.createSubTaskDecorator(pm, userGroupTaskInstanceServiceDecorator, queryService);
        ((TaskDeadlinesServiceImpl)deadlinesService).setTaskContentService(contentService);
        ((TaskDeadlinesServiceImpl)deadlinesService).setTaskQueryService(queryService);
        DeadlinesDecorator deadlinesDecorator = HumanTaskServiceFactory.createDeadlinesDecorator(pm, queryService, deadlinesService, subTaskDecorator);
        ((TaskServiceEntryPointImpl)service).setTaskInstanceService(deadlinesDecorator);
        RuleContextProviderImpl ruleProvider = new RuleContextProviderImpl();
        ruleProvider.initialize();
        TaskRuleServiceImpl taskRuleService = new TaskRuleServiceImpl();
        taskRuleService.setRuleContextProvider(ruleProvider);
        ((TaskServiceEntryPointImpl)service).setTaskRuleService(taskRuleService);
    }

    public static void setJbpmServicesTransactionManager(JbpmServicesTransactionManager txmgr) {
        jbpmTransactionManager = txmgr;
    }

    public static void configurePersistenceManager() {
        EntityManager em = emf.createEntityManager();
        ((JbpmServicesPersistenceManagerImpl)pm).setEm(em);
        ((JbpmServicesPersistenceManagerImpl)pm).setTransactionManager(jbpmTransactionManager);
    }

    public static void setEntityManagerFactory(EntityManagerFactory emf) {
        HumanTaskServiceFactory.emf = emf;
    }

    public static EntityManagerFactory getEntityManagerFactory() {
        return emf;
    }

    public static void configureTaskQueryService(JbpmServicesPersistenceManager pm) {
        ((TaskQueryServiceImpl)queryService).setPm(pm);
    }

    public static void configureTaskIdentityService(JbpmServicesPersistenceManager pm) {
        ((TaskIdentityServiceImpl)identityService).setPm(pm);
    }

    public static void configureTaskAdminService(JbpmServicesPersistenceManager pm) {
        ((TaskAdminServiceImpl)adminService).setPm(pm);
    }

    public static void configureTaskContentService(JbpmServicesPersistenceManager pm) {
        ((TaskContentServiceImpl)contentService).setPm(pm);
    }

    public static void configureTaskDeadlinesService(JbpmServicesPersistenceManager pm) {
        ((TaskDeadlinesServiceImpl)deadlinesService).setTaskContentService(contentService);
        ((TaskDeadlinesServiceImpl)deadlinesService).setTaskQueryService(queryService);
        ((TaskDeadlinesServiceImpl)deadlinesService).setPm(pm);
        ((TaskDeadlinesServiceImpl)deadlinesService).setNotificationEvents(((TaskServiceEntryPointImpl)service).getTaskNotificationEventListeners());
        ((TaskDeadlinesServiceImpl)deadlinesService).init();
    }

    public static void configureTaskInstanceService(JbpmServicesPersistenceManager pm, TaskQueryService queryService) {
        ((TaskInstanceServiceImpl)instanceService).setPm(pm);
        ((TaskInstanceServiceImpl)instanceService).setTaskQueryService(queryService);
        ((TaskInstanceServiceImpl)instanceService).setTaskEvents(((TaskServiceEntryPointImpl)service).getTaskLifecycleEventListeners());
    }

    public static void configureLifeCycleManager(JbpmServicesPersistenceManager pm, TaskIdentityService identityService, TaskQueryService queryService, TaskContentService contentService) {
        ((MVELLifeCycleManager)lifeCycleManager).setPm(pm);
        ((MVELLifeCycleManager)lifeCycleManager).setTaskIdentityService(identityService);
        ((MVELLifeCycleManager)lifeCycleManager).setTaskQueryService(queryService);
        ((MVELLifeCycleManager)lifeCycleManager).setTaskContentService(contentService);
        ((MVELLifeCycleManager)lifeCycleManager).setTaskEvents(((TaskServiceEntryPointImpl)service).getTaskLifecycleEventListeners());
        ((MVELLifeCycleManager)lifeCycleManager).initMVELOperations();
    }

    public static void configureUserGroupLifeCycleManagerDecorator(JbpmServicesPersistenceManager pm, LifeCycleManager lifeCycleManager, UserGroupCallback userGroupCallback) {
        userGroupLifeCycleDecorator.setManager(lifeCycleManager);
        userGroupLifeCycleDecorator.setPm(pm);
        userGroupLifeCycleDecorator.setUserGroupCallback(userGroupCallback);
    }

    public static UserGroupCallback createUserGroupCallback() {
        return new MvelUserGroupCallbackImpl();
    }

    public static SubTaskDecorator createSubTaskDecorator(JbpmServicesPersistenceManager pm, TaskInstanceService instanceService, TaskQueryService queryService) {
        SubTaskDecorator subTaskDecorator = new SubTaskDecorator();
        subTaskDecorator.setPm(pm);
        subTaskDecorator.setInstanceService(instanceService);
        subTaskDecorator.setQueryService(queryService);
        return subTaskDecorator;
    }

    public static DeadlinesDecorator createDeadlinesDecorator(JbpmServicesPersistenceManager pm, TaskQueryService queryService, TaskDeadlinesService deadlinesService, SubTaskDecorator subTaskDecorator) {
        DeadlinesDecorator deadlinesDecorator = new DeadlinesDecorator();
        deadlinesDecorator.setPm(pm);
        deadlinesDecorator.setQueryService(queryService);
        deadlinesDecorator.setDeadlineService(deadlinesService);
        deadlinesDecorator.setInstanceService(subTaskDecorator);
        return deadlinesDecorator;
    }

    private static TaskQueryService configureUserGroupQueryServiceDecorator(TaskQueryService queryService, UserGroupCallback userGroupCallback) {
        UserGroupTaskQueryServiceDecorator userGroupTaskQueryServiceDecorator = new UserGroupTaskQueryServiceDecorator();
        userGroupTaskQueryServiceDecorator.setPm(pm);
        userGroupTaskQueryServiceDecorator.setUserGroupCallback(userGroupCallback);
        userGroupTaskQueryServiceDecorator.setDelegate(queryService);
        return userGroupTaskQueryServiceDecorator;
    }

    private static TaskInstanceService configureUserGroupTaskInstanceServiceDecorator(TaskInstanceService instanceService, UserGroupCallback userGroupCallback) {
        UserGroupTaskInstanceServiceDecorator userGroupTaskInstanceDecorator = new UserGroupTaskInstanceServiceDecorator();
        userGroupTaskInstanceDecorator.setPm(pm);
        userGroupTaskInstanceDecorator.setUserGroupCallback(userGroupCallback);
        userGroupTaskInstanceDecorator.setDelegate(instanceService);
        return userGroupTaskInstanceDecorator;
    }

    public static void setQueryService(TaskQueryService queryService) {
        HumanTaskServiceFactory.queryService = queryService;
    }

    public static void setIdentityService(TaskIdentityService identityService) {
        HumanTaskServiceFactory.identityService = identityService;
    }

    public static void setAdminService(TaskAdminService adminService) {
        HumanTaskServiceFactory.adminService = adminService;
    }

    public static void setContentService(TaskContentService contentService) {
        HumanTaskServiceFactory.contentService = contentService;
    }

    public static void setDeadlinesService(TaskDeadlinesService deadlinesService) {
        HumanTaskServiceFactory.deadlinesService = deadlinesService;
    }

    public static void setInstanceService(TaskInstanceService instanceService) {
        HumanTaskServiceFactory.instanceService = instanceService;
    }

    public static void setLifeCycleManager(LifeCycleManager lifeCycleManager) {
        HumanTaskServiceFactory.lifeCycleManager = lifeCycleManager;
    }

    public static void setUserGroupLifeCycleDecorator(UserGroupLifeCycleManagerDecorator userGroupLifeCycleDecorator) {
        HumanTaskServiceFactory.userGroupLifeCycleDecorator = userGroupLifeCycleDecorator;
    }

    public static EntityManagerFactory getEmf() {
        return emf;
    }

    public static JbpmServicesTransactionManager getJbpmTransactionManager() {
        return jbpmTransactionManager;
    }

    public static TaskQueryService getQueryService() {
        return queryService;
    }

    public static TaskIdentityService getIdentityService() {
        return identityService;
    }

    public static TaskAdminService getAdminService() {
        return adminService;
    }

    public static TaskContentService getContentService() {
        return contentService;
    }

    public static TaskDeadlinesService getDeadlinesService() {
        return deadlinesService;
    }

    public static TaskInstanceService getInstanceService() {
        return instanceService;
    }

    public static LifeCycleManager getLifeCycleManager() {
        return lifeCycleManager;
    }

    public static UserGroupLifeCycleManagerDecorator getUserGroupLifeCycleDecorator() {
        return userGroupLifeCycleDecorator;
    }

    static {
        jbpmTransactionManager = new JbpmLocalTransactionManager();
        pm = new JbpmServicesPersistenceManagerImpl();
        queryService = new TaskQueryServiceImpl();
        identityService = new TaskIdentityServiceImpl();
        adminService = new TaskAdminServiceImpl();
        contentService = new TaskContentServiceImpl();
        deadlinesService = new TaskDeadlinesServiceImpl();
        instanceService = new TaskInstanceServiceImpl();
        lifeCycleManager = new MVELLifeCycleManager();
        userGroupLifeCycleDecorator = new UserGroupLifeCycleManagerDecorator();
    }
}

