/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import bitronix.tm.resource.jdbc.proxy.JdbcJavaProxyFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LrcXAConnectionJavaProxy
extends JavaProxyBase<Connection> {
    private static final Logger log = LoggerFactory.getLogger(LrcXAConnectionJavaProxy.class);
    private static final Map<String, Method> selfMethodMap = LrcXAConnectionJavaProxy.createMethodMap(LrcXAConnectionJavaProxy.class);
    private LrcXAResource xaResource;
    private final List<ConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();

    public LrcXAConnectionJavaProxy(Connection connection) {
        this.xaResource = new LrcXAResource(connection);
        this.delegate = new JdbcJavaProxyFactory().getProxyConnection(this.xaResource, connection);
    }

    public String toString() {
        return "a JDBC LrcXAConnection on " + this.delegate;
    }

    public XAResource getXAResource() throws SQLException {
        return this.xaResource;
    }

    public void close() throws SQLException {
        ((Connection)this.delegate).close();
        this.fireCloseEvent();
    }

    public Connection getConnection() throws SQLException {
        return (Connection)this.delegate;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    private void fireCloseEvent() {
        if (log.isDebugEnabled()) {
            log.debug("notifying " + this.connectionEventListeners.size() + " connectionEventListeners(s) about closing of " + this);
        }
        for (int i = 0; i < this.connectionEventListeners.size(); ++i) {
            ConnectionEventListener connectionEventListener = this.connectionEventListeners.get(i);
            connectionEventListener.connectionClosed(new ConnectionEvent((PooledConnection)this.delegate));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LrcXAConnectionJavaProxy)) {
            return false;
        }
        LrcXAConnectionJavaProxy other = (LrcXAConnectionJavaProxy)obj;
        return ((Connection)this.delegate).equals(other.delegate);
    }

    public int hashCode() {
        return ((Connection)this.delegate).hashCode();
    }

    @Override
    protected Map<String, Method> getMethodMap() {
        return selfMethodMap;
    }
}

