/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.form.builder.services.model.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.form.builder.services.model.FormItemRepresentation;
import org.jbpm.form.builder.services.model.forms.FormEncodingException;
import org.jbpm.form.builder.services.model.forms.FormEncodingFactory;

public class TabbedPanelRepresentation
extends FormItemRepresentation {
    private List<IndexedString> tabTitles = new ArrayList<IndexedString>();
    private Map<IndexedString, FormItemRepresentation> tabContents = new HashMap<IndexedString, FormItemRepresentation>();
    private String cssClassName;
    private String id;
    private String tabWidth;

    public TabbedPanelRepresentation() {
        super("tabbedPanel");
    }

    public void putTab(int index, String tabTitle, FormItemRepresentation tabContent) {
        if (index >= this.tabTitles.size()) {
            this.tabTitles.add(new IndexedString(index, tabTitle));
        } else {
            IndexedString myTitle = new IndexedString(index, tabTitle);
            IndexedString prevTitle = this.tabTitles.get(index);
            if (prevTitle == null) {
                this.tabTitles.set(index, myTitle);
            } else {
                List<IndexedString> nextValues = this.tabTitles.subList(index, this.tabTitles.size());
                this.tabTitles.removeAll(nextValues);
                this.tabTitles.add(myTitle);
                this.tabTitles.addAll(nextValues);
            }
        }
        this.tabContents.put(new IndexedString(index, tabTitle), tabContent);
    }

    public List<IndexedString> getTabTitles() {
        return this.tabTitles;
    }

    public void setTabTitles(List<IndexedString> tabTitles) {
        this.tabTitles = tabTitles;
    }

    public Map<IndexedString, FormItemRepresentation> getTabContents() {
        return this.tabContents;
    }

    public void setTabContents(Map<IndexedString, FormItemRepresentation> tabContents) {
        this.tabContents = tabContents;
    }

    public String getCssClassName() {
        return this.cssClassName;
    }

    public void setCssClassName(String cssClassName) {
        this.cssClassName = cssClassName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(String tabWidth) {
        this.tabWidth = tabWidth;
    }

    @Override
    public void setDataMap(Map<String, Object> data) throws FormEncodingException {
        String string;
        Integer index;
        Map subData;
        super.setDataMap(data);
        this.cssClassName = (String)data.get("cssClassName");
        this.id = (String)data.get("id");
        this.tabWidth = (String)data.get("tabWidth");
        this.tabTitles.clear();
        List tabTitles = (List)data.get("tabTitles");
        List tabContents = (List)data.get("tabContents");
        for (Object tTitle : tabTitles) {
            subData = (Map)tTitle;
            index = Integer.valueOf(String.valueOf(subData.get("index")));
            string = (String)subData.get("string");
            this.tabTitles.add(new IndexedString(index, string));
        }
        this.tabContents.clear();
        for (Object tContent : tabContents) {
            subData = (Map)tContent;
            index = Integer.valueOf(String.valueOf(subData.get("tabPanelIndex")));
            string = (String)subData.get("tabPanelTitle");
            FormItemRepresentation subRep = (FormItemRepresentation)FormEncodingFactory.getDecoder().decode(subData);
            this.tabContents.put(new IndexedString(index, string), subRep);
        }
    }

    @Override
    public Map<String, Object> getDataMap() {
        Map<String, Object> data = super.getDataMap();
        data.put("cssClassName", this.cssClassName);
        data.put("id", this.id);
        data.put("tabWidth", this.tabWidth);
        ArrayList tabTitlesMap = new ArrayList();
        for (IndexedString inStr : this.tabTitles) {
            HashMap<String, Object> inStrMap = new HashMap<String, Object>();
            inStrMap.put("index", inStr.getIndex());
            inStrMap.put("string", inStr.getString());
            tabTitlesMap.add(inStrMap);
        }
        data.put("tabTitles", tabTitlesMap);
        ArrayList<Map<Object, Object>> tabContentsMap = new ArrayList<Map<Object, Object>>();
        for (Map.Entry<IndexedString, FormItemRepresentation> entry : this.tabContents.entrySet()) {
            Map<Object, Object> subData = entry.getValue() == null ? new HashMap() : entry.getValue().getDataMap();
            subData.put("tabPanelIndex", entry.getKey().getIndex());
            subData.put("tabPanelTitle", entry.getKey().getString());
            tabContentsMap.add(subData);
        }
        data.put("tabContents", tabContentsMap);
        return data;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals;
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TabbedPanelRepresentation)) {
            return false;
        }
        TabbedPanelRepresentation other = (TabbedPanelRepresentation)obj;
        boolean bl = equals = this.cssClassName == null && other.cssClassName == null || this.cssClassName != null && this.cssClassName.equals(other.cssClassName);
        if (!equals) {
            return equals;
        }
        boolean bl2 = equals = this.id == null && other.id == null || this.id != null && this.id.equals(other.id);
        if (!equals) {
            return equals;
        }
        boolean bl3 = equals = this.tabWidth == null && other.tabWidth == null || this.tabWidth != null && this.tabWidth.equals(other.tabWidth);
        if (!equals) {
            return equals;
        }
        boolean bl4 = equals = this.tabTitles == null && other.tabTitles == null || this.tabTitles != null && ((Object)this.tabTitles).equals(other.tabTitles);
        if (!equals) {
            return equals;
        }
        equals = this.tabContents == null && other.tabContents == null || this.tabContents != null && ((Object)this.tabContents.entrySet()).equals(other.tabContents.entrySet());
        return equals;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        int aux = this.cssClassName == null ? 0 : this.cssClassName.hashCode();
        result = 37 * result + aux;
        aux = this.id == null ? 0 : this.id.hashCode();
        result = 37 * result + aux;
        aux = this.tabTitles == null ? 0 : ((Object)this.tabTitles).hashCode();
        result = 37 * result + aux;
        aux = this.tabContents == null ? 0 : ((Object)this.tabContents).hashCode();
        result = 37 * result + aux;
        return result;
    }

    public class IndexedString {
        private int index;
        private String string;

        public IndexedString(int index, String string) {
            this.index = index;
            this.string = string;
        }

        public IndexedString() {
        }

        public int getIndex() {
            return this.index;
        }

        public String getString() {
            return this.string;
        }

        public boolean equals(Object obj) {
            boolean equals;
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IndexedString)) {
                return false;
            }
            IndexedString other = (IndexedString)obj;
            boolean bl = equals = this.index == other.index;
            if (!equals) {
                return equals;
            }
            equals = this.string == null && other.string == null || this.string != null && this.string.equals(other.string);
            return equals;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 37 * result + this.index;
            int aux = this.string == null ? 0 : this.string.hashCode();
            result = 37 * result + aux;
            return result;
        }
    }
}

