/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.core.Bpmn2Import;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskHandler
implements WorkItemHandler {
    public static final String WSDL_IMPORT_TYPE = "http://schemas.xmlsoap.org/wsdl/";
    private static final Logger logger = LoggerFactory.getLogger(ServiceTaskHandler.class);
    private ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    private JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
    private KieSession ksession;
    private int asyncTimeout = 10;
    private ClassLoader classLoader;

    public ServiceTaskHandler() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public ServiceTaskHandler(KieSession ksession) {
        this.ksession = ksession;
        this.classLoader = this.getClass().getClassLoader();
    }

    public ServiceTaskHandler(KieSession ksession, ClassLoader classloader) {
        this.ksession = ksession;
        this.classLoader = classloader;
    }

    public ServiceTaskHandler(KieSession ksession, int timeout) {
        this.ksession = ksession;
        this.asyncTimeout = timeout;
        this.classLoader = this.getClass().getClassLoader();
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String implementation = (String)workItem.getParameter("implementation");
        if ("##WebService".equalsIgnoreCase(implementation)) {
            String interfaceRef = (String)workItem.getParameter("interfaceImplementationRef");
            String operationRef = (String)workItem.getParameter("operationImplementationRef");
            Object parameter = workItem.getParameter("Parameter");
            WSMode mode = WSMode.valueOf(workItem.getParameter("mode") == null ? "SYNC" : ((String)workItem.getParameter("mode")).toUpperCase());
            try {
                Client client = this.getWSClient(workItem, interfaceRef);
                if (client == null) {
                    throw new IllegalStateException("Unable to create client for web service " + interfaceRef + " - " + operationRef);
                }
                switch (mode) {
                    case SYNC: {
                        Object[] result = client.invoke(operationRef, new Object[]{parameter});
                        HashMap<String, Object> output = new HashMap<String, Object>();
                        if (result == null || result.length == 0) {
                            output.put("Result", null);
                        } else {
                            output.put("Result", result[0]);
                        }
                        manager.completeWorkItem(workItem.getId(), output);
                        break;
                    }
                    case ASYNC: {
                        final ClientCallback callback = new ClientCallback();
                        final long workItemId = workItem.getId();
                        client.invoke(callback, operationRef, new Object[]{parameter});
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Object[] result = callback.get((long)ServiceTaskHandler.this.asyncTimeout, TimeUnit.SECONDS);
                                    HashMap<String, Object> output = new HashMap<String, Object>();
                                    if (callback.isDone()) {
                                        if (result == null) {
                                            output.put("Result", null);
                                        } else {
                                            output.put("Result", result[0]);
                                        }
                                    }
                                    ServiceTaskHandler.this.ksession.getWorkItemManager().completeWorkItem(workItemId, output);
                                }
                                catch (Exception e) {
                                    logger.error("Error encountered while invoking ws operation asynchronously ", (Throwable)e);
                                }
                            }
                        }).start();
                        break;
                    }
                    case ONEWAY: {
                        ClientCallback callbackFF = new ClientCallback();
                        client.invoke(callbackFF, operationRef, new Object[]{parameter});
                        manager.completeWorkItem(workItem.getId(), new HashMap());
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e, interfaceRef, operationRef, parameter.getClass().getName(), parameter);
            }
        } else {
            this.executeJavaWorkItem(workItem, manager);
        }
    }

    protected synchronized Client getWSClient(WorkItem workItem, String interfaceRef) {
        if (this.clients.containsKey(interfaceRef)) {
            return this.clients.get(interfaceRef);
        }
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        WorkflowProcessImpl process = (WorkflowProcessImpl)this.ksession.getProcessInstance(processInstanceId).getProcess();
        List typedImports = (List)process.getMetaData("Bpmn2Imports");
        if (typedImports != null) {
            Client client = null;
            for (Bpmn2Import importObj : typedImports) {
                if (!WSDL_IMPORT_TYPE.equalsIgnoreCase(importObj.getType())) continue;
                try {
                    client = this.dcf.createClient(importObj.getLocation(), new QName(importObj.getNamespace(), interfaceRef), this.classLoader, null);
                    this.clients.put(interfaceRef, client);
                    return client;
                }
                catch (Exception e) {
                }
            }
        }
        return null;
    }

    public void executeJavaWorkItem(WorkItem workItem, WorkItemManager manager) {
        String i = (String)workItem.getParameter("Interface");
        String operation = (String)workItem.getParameter("Operation");
        String parameterType = (String)workItem.getParameter("ParameterType");
        Object parameter = workItem.getParameter("Parameter");
        try {
            Class<?> c = Class.forName(i, true, this.classLoader);
            Object instance = c.newInstance();
            Class[] classes = null;
            Object[] params = null;
            if (parameterType != null) {
                classes = new Class[]{Class.forName(parameterType, true, this.classLoader)};
                params = new Object[]{parameter};
            }
            Method method = c.getMethod(operation, classes);
            Object result = method.invoke(instance, params);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("Result", result);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (ClassNotFoundException e) {
            this.handleException(e, i, operation, parameterType, parameter);
        }
        catch (InstantiationException e) {
            this.handleException(e, i, operation, parameterType, parameter);
        }
        catch (IllegalAccessException e) {
            this.handleException(e, i, operation, parameterType, parameter);
        }
        catch (NoSuchMethodException e) {
            this.handleException(e, i, operation, parameterType, parameter);
        }
        catch (InvocationTargetException e) {
            this.handleException(e, i, operation, parameterType, parameter);
        }
    }

    private void handleException(Throwable cause, String service, String operation, String paramType, Object param) {
        WorkItemHandlerRuntimeException wihRe;
        logger.debug("Handling exception {} inside service {} and operation {} with param type {} and value {}", new Object[]{cause.getMessage(), service, operation, paramType, param});
        if (cause instanceof InvocationTargetException) {
            Throwable realCause = cause.getCause();
            wihRe = new WorkItemHandlerRuntimeException(realCause);
            wihRe.setStackTrace(realCause.getStackTrace());
        } else {
            wihRe = new WorkItemHandlerRuntimeException(cause);
            wihRe.setStackTrace(cause.getStackTrace());
        }
        wihRe.setInformation("Interface", (Object)service);
        wihRe.setInformation("Operation", (Object)operation);
        wihRe.setInformation("ParameterType", (Object)paramType);
        wihRe.setInformation("Parameter", param);
        wihRe.setInformation("workItemHandlerType", (Object)this.getClass().getSimpleName());
        throw wihRe;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static enum WSMode {
        SYNC,
        ASYNC,
        ONEWAY;

    }
}

