/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.resource.common.AbstractXAStatefulHolder;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.JmsConnectionHandle;
import bitronix.tm.resource.jms.JmsPooledConnectionMBean;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import bitronix.tm.resource.jms.lrc.LrcXAConnectionFactory;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.ManagementRegistrar;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Scheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsPooledConnection
extends AbstractXAStatefulHolder
implements JmsPooledConnectionMBean {
    private static final Logger log = LoggerFactory.getLogger(JmsPooledConnection.class);
    private volatile XAConnection xaConnection;
    private final PoolingConnectionFactory poolingConnectionFactory;
    private final Set<DualSessionWrapper> sessions = Collections.synchronizedSet(new HashSet());
    private final String jmxName;
    private volatile Date acquisitionDate;
    private volatile Date lastReleaseDate;

    protected JmsPooledConnection(PoolingConnectionFactory poolingConnectionFactory, XAConnection connection) {
        this.poolingConnectionFactory = poolingConnectionFactory;
        this.xaConnection = connection;
        this.lastReleaseDate = new Date(MonotonicClock.currentTimeMillis());
        this.addStateChangeEventListener(new JmsPooledConnectionStateChangeListener());
        if (LrcXAConnectionFactory.class.getName().equals(poolingConnectionFactory.getClassName())) {
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingConnectionFactory.getUniqueName() + " - changing twoPcOrderingPosition to ALWAYS_LAST_POSITION");
            }
            poolingConnectionFactory.setTwoPcOrderingPosition(Scheduler.ALWAYS_LAST_POSITION);
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingConnectionFactory.getUniqueName() + " - changing deferConnectionRelease to true");
            }
            poolingConnectionFactory.setDeferConnectionRelease(true);
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingConnectionFactory.getUniqueName() + " - changing useTmJoin to true");
            }
            poolingConnectionFactory.setUseTmJoin(true);
        }
        this.jmxName = "bitronix.tm:type=JMS,UniqueName=" + ManagementRegistrar.makeValidName(poolingConnectionFactory.getUniqueName()) + ",Id=" + poolingConnectionFactory.incCreatedResourcesCounter();
        ManagementRegistrar.register(this.jmxName, this);
    }

    public XAConnection getXAConnection() {
        return this.xaConnection;
    }

    public PoolingConnectionFactory getPoolingConnectionFactory() {
        return this.poolingConnectionFactory;
    }

    public synchronized RecoveryXAResourceHolder createRecoveryXAResourceHolder() throws JMSException {
        DualSessionWrapper dualSessionWrapper = new DualSessionWrapper(this, false, 0);
        dualSessionWrapper.getSession(true);
        return new RecoveryXAResourceHolder(dualSessionWrapper);
    }

    @Override
    public synchronized void close() throws JMSException {
        if (this.xaConnection != null) {
            this.poolingConnectionFactory.unregister(this);
            this.setState(0);
            this.xaConnection.close();
        }
        this.xaConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<XAResourceHolder> getXAResourceHolders() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            return new ArrayList<XAResourceHolder>(this.sessions);
        }
    }

    @Override
    public Object getConnectionHandle() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("getting connection handle from " + this);
        }
        int oldState = this.getState();
        this.setState(2);
        if (oldState == 1) {
            if (log.isDebugEnabled()) {
                log.debug("connection " + this.xaConnection + " was in state IN_POOL, testing it");
            }
            this.testXAConnection();
        } else if (log.isDebugEnabled()) {
            log.debug("connection " + this.xaConnection + " was in state " + Decoder.decodeXAStatefulHolderState(oldState) + ", no need to test it");
        }
        if (log.isDebugEnabled()) {
            log.debug("got connection handle from " + this);
        }
        return new JmsConnectionHandle(this, this.xaConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testXAConnection() throws JMSException {
        if (!this.poolingConnectionFactory.getTestConnections()) {
            if (log.isDebugEnabled()) {
                log.debug("not testing connection of " + this);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("testing connection of " + this);
        }
        XASession xaSession = this.xaConnection.createXASession();
        try {
            TemporaryQueue tq = xaSession.createTemporaryQueue();
            tq.delete();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            xaSession.close();
            throw throwable;
        }
        xaSession.close();
    }

    protected void release() throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug("releasing to pool " + this);
        }
        this.closePendingSessions();
        try {
            TransactionContextHelper.requeue(this, this.poolingConnectionFactory);
        }
        catch (BitronixSystemException ex) {
            throw (JMSException)new JMSException("error requeueing " + this).initCause((Throwable)((Object)ex));
        }
        if (log.isDebugEnabled()) {
            log.debug("released to pool " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePendingSessions() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            for (DualSessionWrapper dualSessionWrapper : this.sessions) {
                if (dualSessionWrapper.getState() != 2) continue;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("trying to close pending session " + dualSessionWrapper);
                    }
                    dualSessionWrapper.close();
                }
                catch (JMSException ex) {
                    log.warn("error closing pending session " + dualSessionWrapper, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            DualSessionWrapper sessionHandle = this.getNotAccessibleSession();
            if (sessionHandle == null) {
                if (log.isDebugEnabled()) {
                    log.debug("no session handle found in NOT_ACCESSIBLE state, creating new session");
                }
                sessionHandle = new DualSessionWrapper(this, transacted, acknowledgeMode);
                sessionHandle.addStateChangeEventListener(new JmsConnectionHandleStateChangeListener());
                this.sessions.add(sessionHandle);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("found session handle in NOT_ACCESSIBLE state, recycling it: " + sessionHandle);
                }
                sessionHandle.setState(2);
            }
            return sessionHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DualSessionWrapper getNotAccessibleSession() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            if (log.isDebugEnabled()) {
                log.debug(this.sessions.size() + " session(s) open from " + this);
            }
            for (DualSessionWrapper sessionHandle : this.sessions) {
                if (sessionHandle.getState() != 3) continue;
                return sessionHandle;
            }
            return null;
        }
    }

    @Override
    public Date getLastReleaseDate() {
        return this.lastReleaseDate;
    }

    public String toString() {
        return "a JmsPooledConnection of pool " + this.poolingConnectionFactory.getUniqueName() + " in state " + Decoder.decodeXAStatefulHolderState(this.getState()) + " with underlying connection " + this.xaConnection;
    }

    @Override
    public String getStateDescription() {
        return Decoder.decodeXAStatefulHolderState(this.getState());
    }

    @Override
    public Date getAcquisitionDate() {
        return this.acquisitionDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getTransactionGtridsCurrentlyHoldingThis() {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            HashSet<String> result = new HashSet<String>();
            for (DualSessionWrapper dsw : this.sessions) {
                result.addAll(dsw.getXAResourceHolderStateGtrids());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResourceHolder getXAResourceHolderForXaResource(XAResource xaResource) {
        Set<DualSessionWrapper> set = this.sessions;
        synchronized (set) {
            for (DualSessionWrapper xaResourceHolder : this.sessions) {
                if (xaResourceHolder.getXAResource() != xaResource) continue;
                return xaResourceHolder;
            }
            return null;
        }
    }

    private final class JmsConnectionHandleStateChangeListener
    implements StateChangeListener {
        private JmsConnectionHandleStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(XAStatefulHolder source, int oldState, int newState) {
            if (newState == 0) {
                Set set = JmsPooledConnection.this.sessions;
                synchronized (set) {
                    JmsPooledConnection.this.sessions.remove(source);
                    if (log.isDebugEnabled()) {
                        log.debug("DualSessionWrapper has been closed, " + JmsPooledConnection.this.sessions.size() + " session(s) left open in pooled connection");
                    }
                }
            }
        }

        public void stateChanging(XAStatefulHolder source, int currentState, int futureState) {
        }
    }

    private final class JmsPooledConnectionStateChangeListener
    implements StateChangeListener {
        private JmsPooledConnectionStateChangeListener() {
        }

        public void stateChanged(XAStatefulHolder source, int oldState, int newState) {
            if (newState == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("requeued JMS connection of " + JmsPooledConnection.this.poolingConnectionFactory);
                }
                JmsPooledConnection.this.lastReleaseDate = new Date(MonotonicClock.currentTimeMillis());
            }
            if (oldState == 1 && newState == 2) {
                JmsPooledConnection.this.acquisitionDate = new Date(MonotonicClock.currentTimeMillis());
            }
            if (newState == 0) {
                ManagementRegistrar.unregister(JmsPooledConnection.this.jmxName);
            }
        }

        public void stateChanging(XAStatefulHolder source, int currentState, int futureState) {
        }
    }
}

