/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet;

import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.Template;

public class TemplateDispatcher
extends Uniform {
    private volatile Context context;

    public TemplateDispatcher(Context context) {
        this.context = context;
    }

    protected void doHandle(Request request, Response response) {
        request.setOriginalRef(request.getResourceRef().getTargetRef());
    }

    public Context getContext() {
        return this.context;
    }

    public Logger getLogger() {
        return this.getContext().getLogger();
    }

    public void handle(Request request, Response response) {
        Response.setCurrent(response);
        Protocol protocol = request.getProtocol();
        if (protocol == null) {
            throw new UnsupportedOperationException("Unable to determine the protocol to use for this call.");
        }
        String targetUri = request.getResourceRef().toString(true, false);
        if (targetUri.contains("{")) {
            Template template = new Template(targetUri);
            request.setResourceRef(template.format(request, response));
        }
        this.doHandle(request, response);
        if (response.getEntity() != null && response.getEntity().getIdentifier() == null) {
            response.getEntity().setIdentifier(request.getResourceRef().toString());
        }
    }
}

