/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.type.BasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.StringRepresentableType;
import org.hibernate.type.Type;
import org.hibernate.type.XmlRepresentableType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public abstract class AbstractStandardBasicType<T>
implements BasicType,
StringRepresentableType<T>,
XmlRepresentableType<T> {
    private static final Size DEFAULT_SIZE = new Size(19, 2, 255L, Size.LobMultiplier.NONE);
    private final Size dictatedSize = new Size();
    private SqlTypeDescriptor sqlTypeDescriptor;
    private JavaTypeDescriptor<T> javaTypeDescriptor;

    public AbstractStandardBasicType(SqlTypeDescriptor sqlTypeDescriptor, JavaTypeDescriptor<T> javaTypeDescriptor) {
        this.sqlTypeDescriptor = sqlTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    public T fromString(String string) {
        return this.javaTypeDescriptor.fromString(string);
    }

    @Override
    public String toString(T value) {
        return this.javaTypeDescriptor.toString(value);
    }

    @Override
    public T fromStringValue(String xml) throws HibernateException {
        return this.fromString(xml);
    }

    @Override
    public String toXMLString(T value, SessionFactoryImplementor factory) throws HibernateException {
        return this.toString(value);
    }

    @Override
    public T fromXMLString(String xml, Mapping factory) throws HibernateException {
        return StringHelper.isEmpty(xml) ? null : (T)this.fromStringValue(xml);
    }

    protected MutabilityPlan<T> getMutabilityPlan() {
        return this.javaTypeDescriptor.getMutabilityPlan();
    }

    protected T getReplacement(T original, T target, SessionImplementor session) {
        if (!this.isMutable()) {
            return original;
        }
        if (this.isEqual(original, target)) {
            return original;
        }
        return this.deepCopy(original);
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public String[] getRegistrationKeys() {
        String[] stringArray;
        if (this.registerUnderJavaType()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.getName();
            stringArray = stringArray2;
            stringArray2[1] = this.javaTypeDescriptor.getJavaTypeClass().getName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.getName();
        }
        return stringArray;
    }

    protected boolean registerUnderJavaType() {
        return false;
    }

    protected static Size getDefaultSize() {
        return DEFAULT_SIZE;
    }

    protected Size getDictatedSize() {
        return this.dictatedSize;
    }

    public final JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public final void setJavaTypeDescriptor(JavaTypeDescriptor<T> javaTypeDescriptor) {
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    public final SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptor;
    }

    public final void setSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        this.sqlTypeDescriptor = sqlTypeDescriptor;
    }

    @Override
    public final Class getReturnedClass() {
        return this.javaTypeDescriptor.getJavaTypeClass();
    }

    @Override
    public final int getColumnSpan(Mapping mapping) throws MappingException {
        return this.sqlTypes(mapping).length;
    }

    @Override
    public final int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{this.sqlTypeDescriptor.getSqlType()};
    }

    @Override
    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return new Size[]{this.getDictatedSize()};
    }

    @Override
    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return new Size[]{AbstractStandardBasicType.getDefaultSize()};
    }

    @Override
    public final boolean isAssociationType() {
        return false;
    }

    @Override
    public final boolean isCollectionType() {
        return false;
    }

    @Override
    public final boolean isComponentType() {
        return false;
    }

    @Override
    public final boolean isEntityType() {
        return false;
    }

    @Override
    public final boolean isAnyType() {
        return false;
    }

    @Override
    public final boolean isXMLElement() {
        return false;
    }

    @Override
    public final boolean isSame(Object x, Object y) {
        return this.isEqual(x, y);
    }

    @Override
    public final boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) {
        return this.isEqual(x, y);
    }

    @Override
    public final boolean isEqual(Object one, Object another) {
        return this.javaTypeDescriptor.areEqual(one, another);
    }

    @Override
    public final int getHashCode(Object x) {
        return this.javaTypeDescriptor.extractHashCode(x);
    }

    @Override
    public final int getHashCode(Object x, SessionFactoryImplementor factory) {
        return this.getHashCode(x);
    }

    @Override
    public final int compare(Object x, Object y) {
        return this.javaTypeDescriptor.getComparator().compare(x, y);
    }

    @Override
    public final boolean isDirty(Object old, Object current, SessionImplementor session) {
        return this.isDirty(old, current);
    }

    @Override
    public final boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) {
        return checkable[0] && this.isDirty(old, current);
    }

    protected final boolean isDirty(Object old, Object current) {
        return !this.isSame(old, current);
    }

    @Override
    public final boolean isModified(Object oldHydratedState, Object currentState, boolean[] checkable, SessionImplementor session) {
        return this.isDirty(oldHydratedState, currentState);
    }

    @Override
    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws SQLException {
        return this.nullSafeGet(rs, names[0], session);
    }

    @Override
    public final Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws SQLException {
        return this.nullSafeGet(rs, name, session);
    }

    public final T nullSafeGet(ResultSet rs, String name, SessionImplementor session) throws SQLException {
        WrapperOptions options = this.getOptions(session);
        return this.nullSafeGet(rs, name, options);
    }

    protected final T nullSafeGet(ResultSet rs, String name, WrapperOptions options) throws SQLException {
        return this.remapSqlTypeDescriptor(options).getExtractor(this.javaTypeDescriptor).extract(rs, name, options);
    }

    public Object get(ResultSet rs, String name, SessionImplementor session) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, name, session);
    }

    @Override
    public final void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws SQLException {
        WrapperOptions options = this.getOptions(session);
        this.nullSafeSet(st, value, index, options);
    }

    protected final void nullSafeSet(PreparedStatement st, Object value, int index, WrapperOptions options) throws SQLException {
        this.remapSqlTypeDescriptor(options).getBinder(this.javaTypeDescriptor).bind(st, value, index, options);
    }

    protected SqlTypeDescriptor remapSqlTypeDescriptor(WrapperOptions options) {
        return options.remapSqlTypeDescriptor(this.sqlTypeDescriptor);
    }

    public void set(PreparedStatement st, T value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index, session);
    }

    @Override
    public final String toLoggableString(Object value, SessionFactoryImplementor factory) {
        return this.javaTypeDescriptor.extractLoggableRepresentation(value);
    }

    @Override
    public final void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) {
        node.setText(this.toString(value));
    }

    @Override
    public final Object fromXMLNode(Node xml, Mapping factory) {
        return this.fromString(xml.getText());
    }

    @Override
    public final boolean isMutable() {
        return this.getMutabilityPlan().isMutable();
    }

    @Override
    public final Object deepCopy(Object value, SessionFactoryImplementor factory) {
        return this.deepCopy(value);
    }

    protected final T deepCopy(T value) {
        return this.getMutabilityPlan().deepCopy(value);
    }

    @Override
    public final Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().disassemble(value);
    }

    @Override
    public final Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().assemble(cached);
    }

    @Override
    public final void beforeAssemble(Serializable cached, SessionImplementor session) {
    }

    @Override
    public final Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names, session, owner);
    }

    @Override
    public final Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return value;
    }

    @Override
    public final Object semiResolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return value;
    }

    @Override
    public final Type getSemiResolvedType(SessionFactoryImplementor factory) {
        return this;
    }

    @Override
    public final Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) {
        return this.getReplacement(original, target, session);
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT == foreignKeyDirection ? this.getReplacement(original, target, session) : target;
    }

    private WrapperOptions getOptions(final SessionImplementor session) {
        return new WrapperOptions(){

            @Override
            public boolean useStreamForLobBinding() {
                return Environment.useStreamsForBinary() || session.getFactory().getDialect().useInputStreamToInsertBlob();
            }

            @Override
            public LobCreator getLobCreator() {
                return Hibernate.getLobCreator(session);
            }

            @Override
            public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
                SqlTypeDescriptor remapped = sqlTypeDescriptor.canBeRemapped() ? session.getFactory().getDialect().remapSqlTypeDescriptor(sqlTypeDescriptor) : sqlTypeDescriptor;
                return remapped == null ? sqlTypeDescriptor : remapped;
            }
        };
    }
}

