/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.inject.Alternative;
import org.jbpm.shared.services.cdi.Selectable;
import org.kie.internal.task.api.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Selectable
public class JBossUserGroupCallbackImpl
implements UserGroupCallback {
    private static final Logger logger = LoggerFactory.getLogger(JBossUserGroupCallbackImpl.class);
    private Map<String, List<String>> groupStore = new HashMap<String, List<String>>();
    private Set<String> allgroups = new HashSet<String>();

    public JBossUserGroupCallbackImpl() {
        this(System.getProperty("jbpm.user.group.mapping", "file:" + System.getProperty("jboss.server.config.dir") + "/roles.properties"));
    }

    public JBossUserGroupCallbackImpl(String location) {
        URL locationUrl = null;
        Properties userGroups = null;
        try {
            if (location.startsWith("classpath:")) {
                String stripedLocation = location.replaceFirst("classpath:", "");
                locationUrl = this.getClass().getResource(stripedLocation);
            } else {
                locationUrl = new URL(location);
            }
            userGroups = new Properties();
            userGroups.load(locationUrl.openStream());
        }
        catch (Exception e) {
            logger.error("Error when loading group information for callback from location: " + location, (Throwable)e);
        }
        this.init(userGroups);
    }

    public JBossUserGroupCallbackImpl(Properties userGroups) {
        this.init(userGroups);
    }

    protected void init(Properties userGroups) {
        if (userGroups == null) {
            throw new IllegalArgumentException("UserGroups properties cannot be null");
        }
        List<String> groups = null;
        for (String string : userGroups.keySet()) {
            groups = Arrays.asList(userGroups.getProperty(string, "").split(","));
            this.groupStore.put(string, groups);
            this.allgroups.addAll(groups);
        }
        if (!this.groupStore.containsKey("Administrator")) {
            this.groupStore.put("Administrator", Collections.singletonList("Administrators"));
            this.allgroups.add("Administrators");
        }
    }

    public boolean existsUser(String userId) {
        return this.groupStore.containsKey(userId);
    }

    public boolean existsGroup(String groupId) {
        return this.allgroups.contains(groupId);
    }

    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        List<String> groups = this.groupStore.get(userId);
        return groups;
    }
}

