/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.command.impl.ContextImpl;
import org.drools.core.command.impl.FixedKnowledgeCommandContext;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.WorkingMemoryFactory;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.event.WorkingMemoryEventListener;
import org.drools.core.event.WorkingMemoryEventSupport;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.agent.KnowledgeAgent;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class StatelessKnowledgeSessionImpl
extends AbstractRuntime
implements StatelessKnowledgeSession,
StatelessKieSession {
    private InternalRuleBase ruleBase;
    private KnowledgeAgent kagent;
    private MapGlobalResolver sessionGlobals = new MapGlobalResolver();
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    public Map<org.kie.api.event.rule.WorkingMemoryEventListener, WorkingMemoryEventListener> mappedWorkingMemoryListeners;
    public Map<AgendaEventListener, org.drools.core.event.AgendaEventListener> mappedAgendaListeners;
    public Set<ProcessEventListener> cachedProcessEventListener;
    private AgendaEventSupport agendaEventSupport = new AgendaEventSupport();
    private WorkingMemoryEventSupport workingMemoryEventSupport = new WorkingMemoryEventSupport();
    private ProcessEventSupport processEventSupport = new ProcessEventSupport();
    private boolean initialized;
    private KieSessionConfiguration conf;
    private Environment environment;
    private transient StatefulKnowledgeSession ksession;
    private WorkingMemoryFactory wmFactory;

    public StatelessKnowledgeSessionImpl() {
    }

    public StatelessKnowledgeSessionImpl(InternalRuleBase ruleBase, KnowledgeAgent kagent, KieSessionConfiguration conf) {
        this.ruleBase = ruleBase;
        this.kagent = kagent;
        this.conf = conf != null ? conf : SessionConfiguration.getDefaultInstance();
        this.environment = EnvironmentFactory.newEnvironment();
        this.wmFactory = ruleBase.getConfiguration().getComponentFactory().getWorkingMemoryFactory();
    }

    public InternalRuleBase getRuleBase() {
        if (this.kagent != null) {
            this.ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kagent.getKnowledgeBase()).ruleBase;
        }
        return this.ruleBase;
    }

    public KnowledgeAgent getKnowledgeAgent() {
        return this.kagent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulKnowledgeSession newWorkingMemory() {
        if (this.ksession != null && ((StatefulKnowledgeSessionImpl)this.ksession).isAlive()) {
            return this.ksession;
        }
        if (this.kagent != null) {
            this.ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kagent.getKnowledgeBase()).ruleBase;
        }
        this.ruleBase.readLock();
        try {
            AbstractWorkingMemory wm = (AbstractWorkingMemory)this.wmFactory.createWorkingMemory(this.ruleBase.nextWorkingMemoryCounter(), this.ruleBase, (SessionConfiguration)this.conf, this.environment);
            this.ksession = new StatefulKnowledgeSessionImpl(wm, new KnowledgeBaseImpl(this.ruleBase));
            ((Globals)wm.getGlobalResolver()).setDelegate((Globals)this.sessionGlobals);
            if (!this.initialized) {
                this.registerSystemListeners(wm);
                this.registerCustomListeners();
                this.initialized = true;
            }
            wm.setAgendaEventSupport(this.agendaEventSupport);
            wm.setWorkingMemoryEventSupport(this.workingMemoryEventSupport);
            InternalProcessRuntime processRuntime = wm.getProcessRuntime();
            if (processRuntime != null) {
                processRuntime.setProcessEventSupport(this.processEventSupport);
            }
            for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
                wm.registerChannel(entry.getKey(), entry.getValue());
            }
            StatefulKnowledgeSession statefulKnowledgeSession = this.ksession;
            return statefulKnowledgeSession;
        }
        finally {
            this.ruleBase.readUnlock();
        }
    }

    private void registerSystemListeners(AbstractWorkingMemory wm) {
        for (EventListener listener : wm.getAgendaEventSupport().getEventListeners()) {
            this.agendaEventSupport.addEventListener(listener);
        }
        for (EventListener listener : wm.getWorkingMemoryEventSupport().getEventListeners()) {
            this.workingMemoryEventSupport.addEventListener(listener);
        }
        InternalProcessRuntime processRuntime = wm.getProcessRuntime();
        if (processRuntime != null) {
            for (ProcessEventListener listener : processRuntime.getProcessEventListeners()) {
                this.processEventSupport.addEventListener(listener);
            }
        }
    }

    private void registerCustomListeners() {
        if (this.mappedAgendaListeners != null) {
            for (org.drools.core.event.AgendaEventListener agendaListener : this.mappedAgendaListeners.values()) {
                this.agendaEventSupport.addEventListener(agendaListener);
            }
        }
        if (this.mappedWorkingMemoryListeners != null) {
            for (WorkingMemoryEventListener wmListener : this.mappedWorkingMemoryListeners.values()) {
                this.workingMemoryEventSupport.addEventListener(wmListener);
            }
        }
        if (this.cachedProcessEventListener != null) {
            for (ProcessEventListener processListener : this.cachedProcessEventListener) {
                this.processEventSupport.addEventListener(processListener);
            }
        }
    }

    public void addEventListener(AgendaEventListener listener) {
        this.registerAgendaEventListener(listener, new StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper(listener));
    }

    public void addAgendaEventListener(org.drools.core.event.AgendaEventListener listener) {
        this.registerAgendaEventListener(new AgendaEventListenerPlaceholder(), listener);
    }

    private void registerAgendaEventListener(AgendaEventListener listener, org.drools.core.event.AgendaEventListener wrapper) {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, org.drools.core.event.AgendaEventListener>();
        }
        this.mappedAgendaListeners.put(listener, wrapper);
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, org.drools.core.event.AgendaEventListener>();
        }
        return Collections.unmodifiableCollection(this.mappedAgendaListeners.keySet());
    }

    public void removeEventListener(AgendaEventListener listener) {
        if (this.mappedAgendaListeners != null) {
            org.drools.core.event.AgendaEventListener wrapper = this.mappedAgendaListeners.remove(listener);
            this.agendaEventSupport.removeEventListener(wrapper);
        }
    }

    public void addWorkingMemoryEventListener(WorkingMemoryEventListener listener) {
        this.registerWorkingMemoryEventListener(new WorkingMemoryEventListenerPlaceholder(), listener);
    }

    public void addEventListener(org.kie.api.event.rule.WorkingMemoryEventListener listener) {
        this.registerWorkingMemoryEventListener(listener, new StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper(listener));
    }

    private void registerWorkingMemoryEventListener(org.kie.api.event.rule.WorkingMemoryEventListener listener, WorkingMemoryEventListener wrapper) {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<org.kie.api.event.rule.WorkingMemoryEventListener, WorkingMemoryEventListener>();
        }
        this.mappedWorkingMemoryListeners.put(listener, wrapper);
    }

    public void removeEventListener(org.kie.api.event.rule.WorkingMemoryEventListener listener) {
        if (this.mappedWorkingMemoryListeners != null) {
            WorkingMemoryEventListener wrapper = this.mappedWorkingMemoryListeners.remove(listener);
            this.workingMemoryEventSupport.removeEventListener(wrapper);
        }
    }

    public Collection<org.kie.api.event.rule.WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<org.kie.api.event.rule.WorkingMemoryEventListener, WorkingMemoryEventListener>();
        }
        return Collections.unmodifiableCollection(this.mappedWorkingMemoryListeners.keySet());
    }

    public void addEventListener(ProcessEventListener listener) {
        if (this.cachedProcessEventListener == null) {
            this.cachedProcessEventListener = new HashSet<ProcessEventListener>();
        }
        this.cachedProcessEventListener.add(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return Collections.unmodifiableCollection(this.cachedProcessEventListener);
    }

    public void removeEventListener(ProcessEventListener listener) {
        if (this.cachedProcessEventListener != null) {
            this.cachedProcessEventListener.remove(listener);
        }
        this.processEventSupport.removeEventListener(listener);
    }

    public void setGlobal(String identifier, Object value) {
        this.sessionGlobals.setGlobal(identifier, value);
    }

    public Globals getGlobals() {
        return this.sessionGlobals;
    }

    public void registerChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    public void unregisterChannel(String name) {
        this.channels.remove(name);
    }

    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public KieBase getKieBase() {
        return this.newWorkingMemory().getKieBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        this.newWorkingMemory();
        FixedKnowledgeCommandContext context = new FixedKnowledgeCommandContext(new ContextImpl("ksession", null), null, null, (KieSession)this.ksession, null);
        try {
            ((StatefulKnowledgeSessionImpl)this.ksession).session.startBatchExecution(new ExecutionResultImpl());
            Object o = ((GenericCommand)command).execute(context);
            boolean autoFireAllRules = true;
            if (command instanceof FireAllRulesCommand) {
                autoFireAllRules = false;
            } else if (command instanceof BatchExecutionCommandImpl) {
                for (GenericCommand<?> nestedCmd : ((BatchExecutionCommandImpl)command).getCommands()) {
                    if (!(nestedCmd instanceof FireAllRulesCommand)) continue;
                    autoFireAllRules = false;
                    break;
                }
            }
            if (autoFireAllRules) {
                this.ksession.fireAllRules();
            }
            if (command instanceof BatchExecutionCommandImpl) {
                ExecutionResultImpl result;
                ExecutionResultImpl executionResultImpl = result = ((StatefulKnowledgeSessionImpl)this.ksession).session.getExecutionResult();
                return (T)executionResultImpl;
            }
            Object t = o;
            return t;
        }
        finally {
            ((StatefulKnowledgeSessionImpl)this.ksession).session.endBatchExecution();
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object object) {
        this.newWorkingMemory();
        try {
            this.ksession.insert(object);
            this.ksession.fireAllRules();
        }
        finally {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Iterable objects) {
        this.newWorkingMemory();
        try {
            for (Object object : objects) {
                this.ksession.insert(object);
            }
            this.ksession.fireAllRules();
        }
        finally {
            this.dispose();
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected void dispose() {
        AbstractWorkingMemory wm = (AbstractWorkingMemory)((StatefulKnowledgeSessionImpl)this.ksession).getInternalWorkingMemory();
        for (EventListener listener : wm.getAgendaEventSupport().getEventListeners()) {
            this.agendaEventSupport.removeEventListener(listener);
        }
        for (EventListener listener : wm.getWorkingMemoryEventSupport().getEventListeners()) {
            this.workingMemoryEventSupport.removeEventListener(listener);
        }
        InternalProcessRuntime processRuntime = wm.getProcessRuntime();
        if (processRuntime != null) {
            for (ProcessEventListener listener : processRuntime.getProcessEventListeners()) {
                this.processEventSupport.removeEventListener(listener);
            }
        }
        this.initialized = false;
        this.ksession.dispose();
        this.ksession = null;
    }

    private static class WorkingMemoryEventListenerPlaceholder
    implements org.kie.api.event.rule.WorkingMemoryEventListener {
        private WorkingMemoryEventListenerPlaceholder() {
        }

        public void objectInserted(ObjectInsertedEvent event) {
        }

        public void objectUpdated(ObjectUpdatedEvent event) {
        }

        public void objectDeleted(ObjectDeletedEvent event) {
        }
    }

    private static class AgendaEventListenerPlaceholder
    implements AgendaEventListener {
        private AgendaEventListenerPlaceholder() {
        }

        public void matchCreated(MatchCreatedEvent event) {
        }

        public void matchCancelled(MatchCancelledEvent event) {
        }

        public void beforeMatchFired(BeforeMatchFiredEvent event) {
        }

        public void afterMatchFired(AfterMatchFiredEvent event) {
        }

        public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
        }

        public void agendaGroupPushed(AgendaGroupPushedEvent event) {
        }

        public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        }

        public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
        }

        public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        }

        public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
        }
    }
}

