/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.CamelLogger;
import org.slf4j.LoggerFactory;

public class LoggingExceptionHandler
implements ExceptionHandler {
    private final CamelLogger logger;

    public LoggingExceptionHandler(Class<?> ownerType) {
        this(new CamelLogger(LoggerFactory.getLogger(ownerType), LoggingLevel.WARN));
    }

    public LoggingExceptionHandler(Class<?> ownerType, LoggingLevel level) {
        this(new CamelLogger(LoggerFactory.getLogger(ownerType), level));
    }

    public LoggingExceptionHandler(CamelLogger logger) {
        this.logger = logger;
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, null, exception);
    }

    @Override
    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    @Override
    public void handleException(String message, Exchange exchange, Throwable exception) {
        try {
            String msg = CamelExchangeException.createExceptionMessage(message, exchange, exception);
            if (this.isCausedByRollbackExchangeException(exception)) {
                this.logger.log(msg);
            } else if (exception != null) {
                this.logger.log(msg, exception);
            } else {
                this.logger.log(msg);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    protected boolean isCausedByRollbackExchangeException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof RollbackExchangeException) {
            return true;
        }
        if (exception.getCause() != null) {
            return this.isCausedByRollbackExchangeException(exception.getCause());
        }
        return false;
    }
}

