/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.CommandsUtil;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskSuspendedEvent;
import org.jbpm.services.task.events.BeforeTaskSuspendedEvent;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.InternalTaskData;

@Transactional
public class SuspendTaskCommand
extends TaskCommand<Void> {
    public SuspendTaskCommand() {
    }

    public SuspendTaskCommand(long taskId, String userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        if (context.getTaskService() != null) {
            context.getTaskService().suspend(this.taskId, this.userId);
            return null;
        }
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId);
        User user = context.getTaskIdentityService().getUserById(this.userId);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskSuspendedEvent>(){}}).fire((Object)task);
        boolean adminAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getBusinessAdministrators());
        boolean potOwnerAllowed = CommandsUtil.isAllowed(user, this.getGroupsIds(), task.getPeopleAssignments().getPotentialOwners());
        boolean ownerAllowed = task.getTaskData().getActualOwner() != null && task.getTaskData().getActualOwner().equals(user);
        boolean noOp = true;
        if (!(adminAllowed || potOwnerAllowed || ownerAllowed)) {
            String errorMessage = "The user" + user + "is not allowed to Start the task " + task.getId();
            throw new PermissionDeniedException(errorMessage);
        }
        if ((potOwnerAllowed || adminAllowed) && task.getTaskData().getStatus().equals((Object)Status.Ready)) {
            ((InternalTaskData)task.getTaskData()).setStatus(Status.Suspended);
            noOp = false;
        }
        if ((ownerAllowed || adminAllowed) && (task.getTaskData().getStatus().equals((Object)Status.Reserved) || task.getTaskData().getStatus().equals((Object)Status.InProgress))) {
            ((InternalTaskData)task.getTaskData()).setStatus(Status.Suspended);
            noOp = false;
        }
        if (noOp) {
            String errorMessage = "User '" + user + "' was unable to execution operation Task Suspend on task id " + task.getId() + " due to a no 'current status' match";
            throw new PermissionDeniedException(errorMessage);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskSuspendedEvent>(){}}).fire((Object)task);
        return null;
    }
}

