/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixException;
import org.apache.helix.alerts.Alert;
import org.apache.helix.alerts.AlertComparator;
import org.apache.helix.alerts.AlertParser;
import org.apache.helix.alerts.AlertValueAndStatus;
import org.apache.helix.alerts.ExpressionParser;
import org.apache.helix.alerts.Operator;
import org.apache.helix.alerts.Stat;
import org.apache.helix.alerts.StatsHolder;
import org.apache.helix.alerts.Tuple;
import org.apache.log4j.Logger;

public class AlertProcessor {
    private static Logger logger = Logger.getLogger(AlertProcessor.class);
    private static final String bindingDelim = ",";
    public static final String noWildcardAlertKey = "*";
    StatsHolder _statsHolder;

    public AlertProcessor(StatsHolder sh) {
        this._statsHolder = sh;
    }

    public static Map<String, List<Tuple<String>>> initAlertStatTuples(Alert alert) {
        String[] alertStats = ExpressionParser.getBaseStats(alert.getExpression());
        HashMap<String, List<Tuple<String>>> alertStatTuples = new HashMap<String, List<Tuple<String>>>();
        for (String currAlertStat : alertStats) {
            ArrayList currList = new ArrayList();
            alertStatTuples.put(currAlertStat, currList);
        }
        return alertStatTuples;
    }

    public static String formAlertKey(ArrayList<String> bindings) {
        if (bindings.size() == 0) {
            return null;
        }
        StringBuilder alertKey = new StringBuilder();
        boolean emptyKey = true;
        for (String binding : bindings) {
            if (!emptyKey) {
                alertKey.append(bindingDelim);
            }
            alertKey.append(binding);
            emptyKey = false;
        }
        return alertKey.toString();
    }

    public static Map<String, ArrayList<Tuple<String>>> populateAlertStatTuples(String[] alertStats, List<Stat> persistentStats) {
        HashMap<String, ArrayList<Tuple<String>>> tupleSets = new HashMap<String, ArrayList<Tuple<String>>>();
        for (Stat persistentStat : persistentStats) {
            if (ExpressionParser.statContainsWildcards(persistentStat.getName())) continue;
            for (int i = 0; i < alertStats.length; ++i) {
                String alertStat = alertStats[i];
                ArrayList<String> wildcardBindings = new ArrayList<String>();
                if (!ExpressionParser.isAlertStatExactMatch(alertStat, persistentStat.getName()) && !ExpressionParser.isAlertStatWildcardMatch(alertStat, persistentStat.getName(), wildcardBindings)) continue;
                String alertKey = wildcardBindings.size() == 0 ? noWildcardAlertKey : AlertProcessor.formAlertKey(wildcardBindings);
                if (!tupleSets.containsKey(alertKey)) {
                    ArrayList<Object> tuples = new ArrayList<Object>(alertStats.length);
                    for (int j = 0; j < alertStats.length; ++j) {
                        tuples.add(j, null);
                    }
                    tupleSets.put(alertKey, tuples);
                }
                ((ArrayList)tupleSets.get(alertKey)).set(i, persistentStat.getValue());
            }
        }
        ArrayList<String> selectedKeysToRemove = new ArrayList<String>();
        block3: for (String setKey : tupleSets.keySet()) {
            ArrayList tupleSet = (ArrayList)tupleSets.get(setKey);
            for (Tuple tup : tupleSet) {
                if (tup != null) continue;
                selectedKeysToRemove.add(setKey);
                continue block3;
            }
        }
        for (String keyToRemove : selectedKeysToRemove) {
            tupleSets.remove(keyToRemove);
        }
        return tupleSets;
    }

    public static List<Iterator<Tuple<String>>> convertTupleRowsToTupleColumns(Map<String, ArrayList<Tuple<String>>> tupleMap) {
        ArrayList columns = new ArrayList();
        ArrayList<Iterator<Tuple<String>>> columnIters = new ArrayList<Iterator<Tuple<String>>>();
        for (String string : tupleMap.keySet()) {
            List currSet = tupleMap.get(string);
            for (int i = 0; i < currSet.size(); ++i) {
                if (columns.size() < i + 1) {
                    ArrayList col = new ArrayList();
                    columns.add(col);
                }
                ((ArrayList)columns.get(i)).add(currSet.get(i));
            }
        }
        for (ArrayList arrayList : columns) {
            columnIters.add(arrayList.iterator());
        }
        return columnIters;
    }

    public static Iterator<Tuple<String>> executeOperatorPipeline(List<Iterator<Tuple<String>>> tupleIters, String[] operators) {
        List<Iterator<Tuple<String>>> nextIters = tupleIters;
        if (operators != null) {
            for (String opName : operators) {
                Operator op = ExpressionParser.getOperator(opName);
                nextIters = op.execute(nextIters);
            }
        }
        if (nextIters.size() != 1) {
            throw new HelixException("operator pipeline produced " + nextIters.size() + " tuple sets instead of exactly 1");
        }
        return nextIters.get(0);
    }

    public static ArrayList<AlertValueAndStatus> executeComparator(Iterator<Tuple<String>> tuples, String comparatorName, Tuple<String> constant) {
        ArrayList<AlertValueAndStatus> results = new ArrayList<AlertValueAndStatus>();
        AlertComparator cmp = AlertParser.getComparator(comparatorName);
        while (tuples.hasNext()) {
            Tuple<String> currTup = tuples.next();
            boolean fired = cmp.evaluate(currTup, constant);
            results.add(new AlertValueAndStatus(currTup, fired));
        }
        return results;
    }

    public static HashMap<String, AlertValueAndStatus> generateResultMap(Set<String> alertStatBindings, ArrayList<AlertValueAndStatus> evalResults) {
        HashMap<String, AlertValueAndStatus> resultMap = new HashMap<String, AlertValueAndStatus>();
        Iterator<String> bindingIter = alertStatBindings.iterator();
        Iterator<AlertValueAndStatus> resultIter = evalResults.iterator();
        if (alertStatBindings.size() != evalResults.size()) {
            while (resultIter.hasNext()) {
                resultMap.put(noWildcardAlertKey, resultIter.next());
            }
        } else {
            while (resultIter.hasNext()) {
                resultMap.put(bindingIter.next(), resultIter.next());
            }
        }
        return resultMap;
    }

    public static HashMap<String, AlertValueAndStatus> executeAlert(Alert alert, List<Stat> persistedStats) {
        String[] alertStats = ExpressionParser.getBaseStats(alert.getExpression());
        Map<String, ArrayList<Tuple<String>>> alertsToTupleRows = AlertProcessor.populateAlertStatTuples(alertStats, persistedStats);
        if (alertsToTupleRows.size() == 0) {
            return null;
        }
        List<Iterator<Tuple<String>>> tupleIters = AlertProcessor.convertTupleRowsToTupleColumns(alertsToTupleRows);
        String[] operators = ExpressionParser.getOperators(alert.getExpression());
        Iterator<Tuple<String>> opResultTuples = AlertProcessor.executeOperatorPipeline(tupleIters, operators);
        ArrayList<AlertValueAndStatus> evalResults = AlertProcessor.executeComparator(opResultTuples, alert.getComparator(), alert.getConstant());
        HashMap<String, AlertValueAndStatus> alertBindingsToResult = AlertProcessor.generateResultMap(alertsToTupleRows.keySet(), evalResults);
        return alertBindingsToResult;
    }

    public static Map<String, Map<String, AlertValueAndStatus>> executeAllAlerts(List<Alert> alerts, List<Stat> stats) {
        HashMap<String, Map<String, AlertValueAndStatus>> alertsResults = new HashMap<String, Map<String, AlertValueAndStatus>>();
        for (Alert alert : alerts) {
            HashMap<String, AlertValueAndStatus> result = AlertProcessor.executeAlert(alert, stats);
            alertsResults.put(alert.getName(), result);
        }
        return alertsResults;
    }
}

