/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.lifecycle.listeners;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.events.AfterTaskActivatedEvent;
import org.jbpm.services.task.events.AfterTaskAddedEvent;
import org.jbpm.services.task.events.AfterTaskClaimedEvent;
import org.jbpm.services.task.events.AfterTaskCompletedEvent;
import org.jbpm.services.task.events.AfterTaskDelegatedEvent;
import org.jbpm.services.task.events.AfterTaskExitedEvent;
import org.jbpm.services.task.events.AfterTaskFailedEvent;
import org.jbpm.services.task.events.AfterTaskForwardedEvent;
import org.jbpm.services.task.events.AfterTaskNominatedEvent;
import org.jbpm.services.task.events.AfterTaskReleasedEvent;
import org.jbpm.services.task.events.AfterTaskResumedEvent;
import org.jbpm.services.task.events.AfterTaskStartedEvent;
import org.jbpm.services.task.events.AfterTaskStoppedEvent;
import org.jbpm.services.task.events.AfterTaskSuspendedEvent;
import org.jbpm.services.task.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Transactional
public class BAMTaskEventListener
implements TaskLifeCycleEventListener {
    private static final Logger logger = LoggerFactory.getLogger(BAMTaskEventListener.class);
    @Inject
    private JbpmServicesPersistenceManager pm;

    @Override
    public void afterTaskStartedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskStartedEvent Task ti) {
        this.createOrUpdateTask(ti, new BAMTaskWorker(){

            @Override
            public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl bamTask, Task task) {
                bamTask.setStartDate(new Date());
                return bamTask;
            }

            @Override
            public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl bamTask, Task task) {
                bamTask.setStartDate(new Date());
                return bamTask;
            }
        });
    }

    @Override
    public void afterTaskActivatedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskActivatedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    @Override
    public void afterTaskClaimedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskClaimedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    @Override
    public void afterTaskCompletedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskCompletedEvent Task ti) {
        this.createOrUpdateTask(ti, new BAMTaskWorker(){

            @Override
            public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl bamTask, Task task) {
                return bamTask;
            }

            @Override
            public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl bamTask, Task task) {
                Date completedDate = new Date();
                bamTask.setEndDate(completedDate);
                bamTask.setDuration(completedDate.getTime() - bamTask.getStartDate().getTime());
                return bamTask;
            }
        });
    }

    @Override
    public void afterTaskAddedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskAddedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    @Override
    public void afterTaskSkippedEvent(Task ti) {
        this.createOrUpdateTask(ti, Status.Exited);
    }

    @Override
    public void afterTaskStoppedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskStoppedEvent Task ti) {
        this.createOrUpdateTask(ti, Status.Exited);
    }

    @Override
    public void afterTaskFailedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskFailedEvent Task ti) {
        this.createOrUpdateTask(ti, Status.Error);
    }

    @Override
    public void afterTaskExitedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskExitedEvent Task ti) {
        this.createOrUpdateTask(ti, Status.Exited);
    }

    public void afterTaskReleasedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskReleasedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    public void afterTaskDelegatedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskDelegatedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    public void afterTaskForwaredEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskForwardedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    public void afterTaskNomiatedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskNominatedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    public void afterTaskResumedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskResumedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    public void afterTaskSuspendedEvent(@Observes(notifyObserver=Reception.ALWAYS) @AfterTaskSuspendedEvent Task ti) {
        this.createOrUpdateTask(ti);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(Task ti, BAMTaskWorker worker) {
        return this.createOrUpdateTask(ti, null, worker);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(Task ti) {
        return this.createOrUpdateTask(ti, null, null);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(Task ti, Status newStatus) {
        return this.createOrUpdateTask(ti, newStatus, null);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(Task ti, Status newStatus, BAMTaskWorker worker) {
        BAMTaskSummaryImpl result = null;
        if (ti == null) {
            logger.error("The task instance does not exist.");
            return result;
        }
        Status status = newStatus != null ? newStatus : ti.getTaskData().getStatus();
        List taskSummaries = (List)this.pm.queryStringWithParametersInTransaction("select bts from BAMTaskSummaryImpl bts where bts.taskId=:taskId", (Map)this.pm.addParametersToMap(new Object[]{"taskId", ti.getId()}));
        if (taskSummaries.isEmpty()) {
            String actualOwner = "";
            if (ti.getTaskData().getActualOwner() != null) {
                actualOwner = ti.getTaskData().getActualOwner().getId();
            }
            result = new BAMTaskSummaryImpl(ti.getId(), ((I18NText)ti.getNames().get(0)).getText(), status.toString(), new Date(), actualOwner, ti.getTaskData().getProcessInstanceId());
            if (worker != null) {
                worker.createTask(result, ti);
            }
            this.pm.persist((Object)result);
        } else if (taskSummaries.size() == 1) {
            result = (BAMTaskSummaryImpl)taskSummaries.get(0);
            result.setStatus(status.toString());
            if (ti.getTaskData().getActualOwner() != null) {
                result.setUserId(ti.getTaskData().getActualOwner().getId());
            }
            if (worker != null) {
                worker.updateTask(result, ti);
            }
            this.pm.merge((Object)result);
        } else {
            logger.warn("Something went wrong with the Task BAM Listener");
            throw new IllegalStateException("We cannot have more than one BAM Task Summary for the task id = " + ti.getId());
        }
        return result;
    }

    protected static interface BAMTaskWorker {
        public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl var1, Task var2);

        public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl var1, Task var2);
    }
}

