/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.ejb.EJBContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.Synchronizations;
import org.jboss.solder.core.Veto;

@Veto
public class CMTTransaction
extends AbstractUserTransaction {
    private final EJBContext ejbContext;

    public CMTTransaction(EJBContext ejbContext, Synchronizations sync) {
        this.setSynchronizations(sync);
        this.ejbContext = ejbContext;
        if (ejbContext == null) {
            throw new IllegalArgumentException("null EJBContext");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.ejbContext.getUserTransaction().begin();
        this.getSynchronizations().afterTransactionBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        UserTransaction userTransaction = this.ejbContext.getUserTransaction();
        boolean success = false;
        Synchronizations synchronizations = this.getSynchronizations();
        synchronizations.beforeTransactionCommit();
        try {
            userTransaction.commit();
            success = true;
        }
        finally {
            synchronizations.afterTransactionCompletion(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        UserTransaction userTransaction = this.ejbContext.getUserTransaction();
        try {
            userTransaction.rollback();
        }
        finally {
            this.getSynchronizations().afterTransactionCompletion(false);
        }
    }

    public int getStatus() throws SystemException {
        try {
            if (!this.ejbContext.getRollbackOnly()) {
                return 0;
            }
            return 1;
        }
        catch (IllegalStateException ise) {
            try {
                return this.ejbContext.getUserTransaction().getStatus();
            }
            catch (IllegalStateException is) {
                return 6;
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.ejbContext.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.ejbContext.getUserTransaction().setTransactionTimeout(timeout);
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        Synchronizations synchronizations = this.getSynchronizations();
        if (!synchronizations.isAwareOfContainerTransactions()) {
            throw new UnsupportedOperationException("cannot register synchronization with container transaction, use <transaction:ejb-transaction/>");
        }
        synchronizations.registerSynchronization(sync);
    }
}

