/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.Synchronizations;
import org.jboss.solder.core.Veto;
import org.jboss.solder.logging.Logger;

@RequestScoped
@DefaultTransaction
@Veto
public class HibernateTransaction
extends AbstractUserTransaction
implements Synchronization {
    private static final Logger log = Logger.getLogger(HibernateTransaction.class);
    @Inject
    private Session session;
    private boolean rollbackOnly;
    private boolean synchronizationRegistered = false;

    @Inject
    public void init(Synchronizations sync) {
        this.setSynchronizations(sync);
    }

    private Transaction getDelegate() {
        return this.session.getTransaction();
    }

    public void begin() throws NotSupportedException, SystemException {
        log.debug((Object)"beginning JPA resource-local transaction");
        this.getDelegate().begin();
        this.getSynchronizations().afterTransactionBegin();
        this.getDelegate().registerSynchronization((Synchronization)this);
        this.synchronizationRegistered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        log.debug((Object)"committing JPA resource-local transaction");
        Transaction delegate = this.getDelegate();
        boolean success = false;
        boolean tempSynchronizationRegistered = this.synchronizationRegistered;
        try {
            if (delegate.isActive()) {
                if (!this.rollbackOnly) {
                    if (!tempSynchronizationRegistered) {
                        this.getSynchronizations().beforeTransactionCommit();
                    }
                    delegate.commit();
                    success = true;
                } else {
                    this.rollback();
                }
            }
        }
        finally {
            if (!tempSynchronizationRegistered) {
                this.getSynchronizations().afterTransactionCompletion(success);
            }
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        log.debug((Object)"rolling back JPA resource-local transaction");
        Transaction delegate = this.getDelegate();
        this.rollbackOnly = false;
        boolean tempSynchronizationRegistered = this.synchronizationRegistered;
        delegate.rollback();
        if (!tempSynchronizationRegistered) {
            this.getSynchronizations().afterTransactionCompletion(false);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        log.debug((Object)"marking JPA resource-local transaction for rollback");
        this.rollbackOnly = true;
    }

    public int getStatus() throws SystemException {
        if (this.getDelegate().isActive()) {
            if (this.rollbackOnly) {
                return 1;
            }
            return 0;
        }
        return 6;
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering synchronization: " + sync));
        }
        this.getDelegate().registerSynchronization(sync);
    }

    @Override
    public boolean isConversationContextRequired() {
        return true;
    }

    @Override
    public void enlist(EntityManager entityManager) {
        throw new RuntimeException("You should not try and enlist an EntityManager in a HibernateTransaction, use EntityTransaction or JTA instead");
    }

    public void afterCompletion(int status) {
        boolean success = 3 == status;
        this.getSynchronizations().afterTransactionCompletion(success);
        this.rollbackOnly = false;
        this.synchronizationRegistered = false;
    }

    public void beforeCompletion() {
        this.getSynchronizations().beforeTransactionCommit();
    }
}

