/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.gui.Console;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Decoder;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TransactionLogDialog
extends JDialog {
    private JPanel labelPanel = new JPanel();
    private JLabel statusLabel = new JLabel("Status");
    private JLabel recordLengthLabel = new JLabel("Record length");
    private JLabel headerLengthLabel = new JLabel("Header length");
    private JLabel timeLabel = new JLabel("Time");
    private JLabel sequenceNumberLabel = new JLabel("Sequence number");
    private JLabel crc32Label = new JLabel("CRC");
    private JLabel gtridLabel = new JLabel("GTRID");
    private JLabel uniqueNamesLabel = new JLabel("Resources");
    private JPanel fieldPanel = new JPanel();
    private JTextField statusField = new JTextField();
    private JTextField recordLengthField = new JTextField();
    private JTextField headerLengthField = new JTextField();
    private JTextField timeField = new JTextField();
    private JTextField sequenceNumberField = new JTextField();
    private JTextField crc32Field = new JTextField();
    private JTextField gtridField = new JTextField();
    private JTextField uniqueNamesField = new JTextField();

    public TransactionLogDialog(JFrame frame, TransactionLogRecord tlog) {
        super(frame, "Transaction log details", true);
        this.statusField.setText(Decoder.decodeStatus(tlog.getStatus()));
        this.recordLengthField.setText("" + tlog.getRecordLength());
        this.headerLengthField.setText("" + tlog.getHeaderLength());
        this.timeField.setText(Console.dateFormatter.format(new Date(tlog.getTime())));
        this.sequenceNumberField.setText("" + tlog.getSequenceNumber());
        if (tlog.isCrc32Correct()) {
            this.crc32Field.setText("" + tlog.getCrc32());
        } else {
            this.crc32Field.setText(tlog.getCrc32() + " (should be: " + tlog.calculateCrc32() + ")");
            this.crc32Field.setBackground(Color.RED);
        }
        this.gtridField.setText(tlog.getGtrid().toString());
        this.uniqueNamesField.setText(this.buildString(tlog.getUniqueNames()));
        this.statusField.setEditable(false);
        this.recordLengthField.setEditable(false);
        this.headerLengthField.setEditable(false);
        this.timeField.setEditable(false);
        this.sequenceNumberField.setEditable(false);
        this.crc32Field.setEditable(false);
        this.gtridField.setEditable(false);
        this.uniqueNamesField.setEditable(false);
        this.labelPanel.add(this.statusLabel);
        this.fieldPanel.add(this.statusField);
        this.labelPanel.add(this.recordLengthLabel);
        this.fieldPanel.add(this.recordLengthField);
        this.labelPanel.add(this.headerLengthLabel);
        this.fieldPanel.add(this.headerLengthField);
        this.labelPanel.add(this.timeLabel);
        this.fieldPanel.add(this.timeField);
        this.labelPanel.add(this.sequenceNumberLabel);
        this.fieldPanel.add(this.sequenceNumberField);
        this.labelPanel.add(this.crc32Label);
        this.fieldPanel.add(this.crc32Field);
        this.labelPanel.add(this.gtridLabel);
        this.fieldPanel.add(this.gtridField);
        this.labelPanel.add(this.uniqueNamesLabel);
        this.fieldPanel.add(this.uniqueNamesField);
        this.labelPanel.setLayout(new GridLayout(8, 1));
        this.fieldPanel.setLayout(new GridLayout(8, 1));
        this.getContentPane().add(this.labelPanel);
        this.getContentPane().add(this.fieldPanel);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.pack();
        int xPos = (frame.getBounds().width - 600) / 2;
        int yPos = (frame.getBounds().height - this.getSize().height) / 2;
        this.setBounds(xPos, yPos, 600, this.getSize().height);
    }

    private String buildString(Set uniqueNames) {
        StringBuilder sb = new StringBuilder();
        Iterator it = uniqueNames.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            sb.append(o);
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

