/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.persistence.TransactionManager;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticAuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(StaticAuditLogService.class);
    private static volatile Environment env;
    private static EntityManagerFactory emf;

    @Deprecated
    public StaticAuditLogService() {
    }

    @Deprecated
    public StaticAuditLogService(Environment env) {
        StaticAuditLogService.env = env;
    }

    public static void setEnvironment(Environment newEnv) {
        env = newEnv;
    }

    public static List<ProcessInstanceLog> findProcessInstances() {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog").getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    public static List<ProcessInstanceLog> findProcessInstances(String processId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId").setParameter("processId", (Object)processId).getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    public static List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = StaticAuditLogService.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId AND p.end is null").setParameter("processId", (Object)processId).getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessInstanceLog findProcessInstance(long processInstanceId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        try {
            ProcessInstanceLog processInstanceLog = (ProcessInstanceLog)StaticAuditLogService.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
            return processInstanceLog;
        }
        catch (NoResultException e) {
            ProcessInstanceLog processInstanceLog = null;
            return processInstanceLog;
        }
        finally {
            StaticAuditLogService.closeEntityManager(em, newTx);
        }
    }

    public static List<ProcessInstanceLog> findSubProcessInstances(long processInstanceId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = StaticAuditLogService.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.parentProcessInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    public static List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = StaticAuditLogService.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    public static List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = StaticAuditLogService.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId AND n.nodeId = :nodeId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).setParameter("nodeId", (Object)nodeId).getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    public static List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = StaticAuditLogService.getEntityManager().createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    public static List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List result = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId AND v.variableId = :variableId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId).getResultList();
        StaticAuditLogService.closeEntityManager(em, newTx);
        return result;
    }

    public static void clear() {
        EntityManager em = StaticAuditLogService.getEntityManager();
        boolean newTx = StaticAuditLogService.joinTransaction(em);
        List processInstances = em.createQuery("FROM ProcessInstanceLog").getResultList();
        for (ProcessInstanceLog processInstance : processInstances) {
            em.remove((Object)processInstance);
        }
        List nodeInstances = em.createQuery("FROM NodeInstanceLog").getResultList();
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            em.remove((Object)nodeInstance);
        }
        List variableInstances = em.createQuery("FROM VariableInstanceLog").getResultList();
        for (VariableInstanceLog variableInstance : variableInstances) {
            em.remove((Object)variableInstance);
        }
        StaticAuditLogService.closeEntityManager(em, newTx);
    }

    @Deprecated
    public static void dispose() {
        if (emf != null) {
            emf.close();
        }
    }

    protected void finalize() throws Throwable {
        if (emf != null) {
            emf.close();
        }
    }

    private static boolean joinTransaction(EntityManager em) {
        Object o;
        Boolean bool;
        boolean isJTA = true;
        if (env != null && (bool = (Boolean)env.get("IS_JTA_TRANSACTION")) != null) {
            isJTA = bool;
        }
        boolean newTx = false;
        TransactionManager transactionManager = null;
        if (env != null && (o = env.get("org.kie.transaction.TransactionManager")) instanceof TransactionManager) {
            transactionManager = (TransactionManager)o;
        }
        if (transactionManager != null) {
            newTx = transactionManager.begin();
        } else {
            UserTransaction ut = null;
            try {
                ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                if (ut.getStatus() == 6) {
                    ut.begin();
                    newTx = true;
                }
            }
            catch (Exception e) {
                logger.error("Unable to find or open a transaction: ", (Throwable)e);
            }
        }
        if (isJTA) {
            em.joinTransaction();
        }
        return newTx;
    }

    private static void closeEntityManager(EntityManager em, boolean newTx) {
        Boolean bool;
        boolean sharedEM = false;
        if (env != null && (bool = (Boolean)env.get("IS_SHARED_ENTITY_MANAGER")) != null) {
            sharedEM = bool;
        }
        if (!sharedEM) {
            Object o;
            em.flush();
            em.clear();
            em.close();
            TransactionManager transactionManager = null;
            if (env != null && (o = env.get("org.kie.transaction.TransactionManager")) instanceof TransactionManager) {
                transactionManager = (TransactionManager)o;
            }
            if (transactionManager != null) {
                transactionManager.commit(newTx);
            } else if (newTx) {
                try {
                    UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
                    ut.commit();
                }
                catch (Exception e) {
                    logger.error("Unable to commit transaction", (Throwable)e);
                }
            }
        }
    }

    private static EntityManager getEntityManager() {
        EntityManager em = null;
        if (env == null) {
            if (emf == null) {
                try {
                    emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to instantiate emf for 'org.jbpm.persistence.jpa' persistence unit, consider using JPAProcessInstanceDbLog.setEnvironment(env)", e);
                }
            }
            em = emf.createEntityManager();
        } else {
            boolean sharedEM = false;
            Boolean bool = (Boolean)env.get("IS_SHARED_ENTITY_MANAGER");
            if (bool != null) {
                sharedEM = bool;
            }
            if (sharedEM) {
                em = (EntityManager)env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            } else {
                EntityManagerFactory emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
                em = emf.createEntityManager();
            }
        }
        return em;
    }
}

