/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public class InstanceConfig
extends HelixProperty {
    private static final Logger _logger = Logger.getLogger((String)InstanceConfig.class.getName());

    public InstanceConfig(String instanceId) {
        super(instanceId);
    }

    public InstanceConfig(ZNRecord record) {
        super(record);
    }

    public String getHostName() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_HOST.toString());
    }

    public void setHostName(String hostName) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_HOST.toString(), hostName);
    }

    public String getPort() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_PORT.toString());
    }

    public void setPort(String port) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_PORT.toString(), port);
    }

    public List<String> getTags() {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            tags = new ArrayList<String>(0);
        }
        return tags;
    }

    public void addTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            tags = new ArrayList<String>(0);
        }
        if (!tags.contains(tag)) {
            tags.add(tag);
        }
        this.getRecord().setListField(InstanceConfigProperty.TAG_LIST.toString(), tags);
    }

    public void removeTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            return;
        }
        if (tags.contains(tag)) {
            tags.remove(tag);
        }
    }

    public boolean containsTag(String tag) {
        List<String> tags = this.getRecord().getListField(InstanceConfigProperty.TAG_LIST.toString());
        if (tags == null) {
            return false;
        }
        return tags.contains(tag);
    }

    public boolean getInstanceEnabled() {
        String isEnabled = this._record.getSimpleField(InstanceConfigProperty.HELIX_ENABLED.toString());
        return isEnabled == null || Boolean.parseBoolean(isEnabled);
    }

    public void setInstanceEnabled(boolean enabled) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_ENABLED.toString(), Boolean.toString(enabled));
    }

    public boolean getInstanceEnabledForPartition(String partition) {
        List<String> disabledPartitions = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
        return disabledPartitions == null || !disabledPartitions.contains(partition);
    }

    public List<String> getDisabledPartitions() {
        return this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
    }

    public void setInstanceEnabledForPartition(String partitionName, boolean enabled) {
        List<String> list = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (list != null) {
            disabledPartitions.addAll(list);
        }
        if (enabled) {
            disabledPartitions.remove(partitionName);
        } else {
            disabledPartitions.add(partitionName);
        }
        list = new ArrayList<String>(disabledPartitions);
        Collections.sort(list);
        this._record.setListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString(), list);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InstanceConfig) {
            InstanceConfig that = (InstanceConfig)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getInstanceName() {
        return this._record.getId();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static enum InstanceConfigProperty {
        HELIX_HOST,
        HELIX_PORT,
        HELIX_ENABLED,
        HELIX_DISABLED_PARTITION,
        TAG_LIST;

    }
}

