/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.deadlines.DeadlinesDecorator;
import org.jbpm.services.task.identity.MvelUserGroupCallbackImpl;
import org.jbpm.services.task.identity.UserGroupLifeCycleManagerDecorator;
import org.jbpm.services.task.identity.UserGroupTaskInstanceServiceDecorator;
import org.jbpm.services.task.identity.UserGroupTaskQueryServiceDecorator;
import org.jbpm.services.task.impl.TaskAdminServiceImpl;
import org.jbpm.services.task.impl.TaskContentServiceImpl;
import org.jbpm.services.task.impl.TaskDeadlinesServiceImpl;
import org.jbpm.services.task.impl.TaskIdentityServiceImpl;
import org.jbpm.services.task.impl.TaskInstanceServiceImpl;
import org.jbpm.services.task.impl.TaskQueryServiceImpl;
import org.jbpm.services.task.impl.TaskServiceEntryPointImpl;
import org.jbpm.services.task.impl.ThrowableInteranlTaskService;
import org.jbpm.services.task.internals.lifecycle.LifeCycleManager;
import org.jbpm.services.task.internals.lifecycle.MVELLifeCycleManager;
import org.jbpm.services.task.rule.impl.RuleContextProviderImpl;
import org.jbpm.services.task.rule.impl.TaskRuleServiceImpl;
import org.jbpm.services.task.subtask.SubTaskDecorator;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmLocalTransactionManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskAdminService;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskIdentityService;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskQueryService;

public class HumanTaskConfigurator {
    private TaskService service;
    private EntityManagerFactory emf;
    private JbpmServicesTransactionManager jbpmTransactionManager = new JbpmLocalTransactionManager();
    private JbpmServicesPersistenceManager pm = new JbpmServicesPersistenceManagerImpl();
    private TaskQueryService queryService = new TaskQueryServiceImpl();
    private TaskIdentityService identityService = new TaskIdentityServiceImpl();
    private TaskAdminService adminService = new TaskAdminServiceImpl();
    private TaskContentService contentService = new TaskContentServiceImpl();
    private TaskDeadlinesService deadlinesService = new TaskDeadlinesServiceImpl();
    private TaskInstanceService instanceService = new TaskInstanceServiceImpl();
    private LifeCycleManager lifeCycleManager = new MVELLifeCycleManager();
    private UserGroupLifeCycleManagerDecorator userGroupLifeCycleDecorator = new UserGroupLifeCycleManagerDecorator();
    private UserGroupCallback userGroupCallback = new MvelUserGroupCallbackImpl();

    public HumanTaskConfigurator transactionManager(JbpmServicesTransactionManager tm) {
        this.jbpmTransactionManager = tm;
        return this;
    }

    public HumanTaskConfigurator entityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
        return this;
    }

    public HumanTaskConfigurator persistenceManager(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
        return this;
    }

    public HumanTaskConfigurator queryService(TaskQueryService queryService) {
        this.queryService = queryService;
        return this;
    }

    public HumanTaskConfigurator identityService(TaskIdentityService identityService) {
        this.identityService = identityService;
        return this;
    }

    public HumanTaskConfigurator adminService(TaskAdminService adminService) {
        this.adminService = adminService;
        return this;
    }

    public HumanTaskConfigurator contentService(TaskContentService contentService) {
        this.contentService = contentService;
        return this;
    }

    public HumanTaskConfigurator deadlinesService(TaskDeadlinesService deadlinesService) {
        this.deadlinesService = deadlinesService;
        return this;
    }

    public HumanTaskConfigurator instanceService(TaskInstanceService instanceService) {
        this.instanceService = instanceService;
        return this;
    }

    public HumanTaskConfigurator lifeCycleManager(LifeCycleManager lifeCycleManager) {
        this.lifeCycleManager = lifeCycleManager;
        return this;
    }

    public HumanTaskConfigurator userGroupCallback(UserGroupCallback userGroupCallback) {
        if (userGroupCallback == null) {
            return this;
        }
        this.userGroupCallback = userGroupCallback;
        return this;
    }

    public TaskService getTaskService() {
        if (this.service == null) {
            this.service = new TaskServiceEntryPointImpl();
            this.configurePersistenceManager();
            this.configureTaskQueryService(this.pm);
            TaskQueryService userGroupQueryServiceDecorator = this.configureUserGroupQueryServiceDecorator(this.queryService, this.userGroupCallback);
            ((TaskServiceEntryPointImpl)this.service).setTaskQueryService(userGroupQueryServiceDecorator);
            this.configureTaskIdentityService(this.pm);
            ((TaskServiceEntryPointImpl)this.service).setTaskIdentityService(this.identityService);
            this.configureTaskAdminService(this.pm);
            ((TaskServiceEntryPointImpl)this.service).setTaskAdminService(this.adminService);
            this.configureTaskContentService(this.pm);
            ((TaskServiceEntryPointImpl)this.service).setTaskContentService(this.contentService);
            this.configureTaskDeadlinesService(this.pm);
            this.configureTaskInstanceService(this.pm, this.queryService);
            this.configureLifeCycleManager(this.pm, this.identityService, this.queryService, this.contentService);
            this.configureUserGroupLifeCycleManagerDecorator(this.pm, this.lifeCycleManager, this.userGroupCallback);
            ((TaskInstanceServiceImpl)this.instanceService).setLifeCycleManager(this.userGroupLifeCycleDecorator);
            TaskInstanceService userGroupTaskInstanceServiceDecorator = this.configureUserGroupTaskInstanceServiceDecorator(this.instanceService, this.userGroupCallback);
            SubTaskDecorator subTaskDecorator = this.createSubTaskDecorator(this.pm, userGroupTaskInstanceServiceDecorator, this.queryService);
            ((TaskDeadlinesServiceImpl)this.deadlinesService).setTaskContentService(this.contentService);
            ((TaskDeadlinesServiceImpl)this.deadlinesService).setTaskQueryService(this.queryService);
            DeadlinesDecorator deadlinesDecorator = this.createDeadlinesDecorator(this.pm, this.queryService, this.deadlinesService, subTaskDecorator);
            ((TaskServiceEntryPointImpl)this.service).setTaskInstanceService(deadlinesDecorator);
            RuleContextProviderImpl ruleProvider = new RuleContextProviderImpl();
            ruleProvider.initialize();
            TaskRuleServiceImpl taskRuleService = new TaskRuleServiceImpl();
            taskRuleService.setRuleContextProvider(ruleProvider);
            ((TaskServiceEntryPointImpl)this.service).setTaskRuleService(taskRuleService);
        }
        return (TaskService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ThrowableInteranlTaskService.class, EventService.class}, (InvocationHandler)new TransactionInterceptor((InternalTaskService)this.service, this.pm));
    }

    protected void configurePersistenceManager() {
        ((JbpmServicesPersistenceManagerImpl)this.pm).setEmf(this.emf);
        ((JbpmServicesPersistenceManagerImpl)this.pm).setTransactionManager(this.jbpmTransactionManager);
    }

    protected void configureTaskQueryService(JbpmServicesPersistenceManager pm) {
        ((TaskQueryServiceImpl)this.queryService).setPm(pm);
    }

    protected void configureTaskIdentityService(JbpmServicesPersistenceManager pm) {
        ((TaskIdentityServiceImpl)this.identityService).setPm(pm);
    }

    protected void configureTaskAdminService(JbpmServicesPersistenceManager pm) {
        ((TaskAdminServiceImpl)this.adminService).setPm(pm);
    }

    protected void configureTaskContentService(JbpmServicesPersistenceManager pm) {
        ((TaskContentServiceImpl)this.contentService).setPm(pm);
    }

    protected void configureTaskDeadlinesService(JbpmServicesPersistenceManager pm) {
        ((TaskDeadlinesServiceImpl)this.deadlinesService).setTaskContentService(this.contentService);
        ((TaskDeadlinesServiceImpl)this.deadlinesService).setTaskQueryService(this.queryService);
        ((TaskDeadlinesServiceImpl)this.deadlinesService).setPm(pm);
        ((TaskDeadlinesServiceImpl)this.deadlinesService).setNotificationEvents(((TaskServiceEntryPointImpl)this.service).getTaskNotificationEventListeners());
        ((TaskDeadlinesServiceImpl)this.deadlinesService).init();
    }

    protected void configureTaskInstanceService(JbpmServicesPersistenceManager pm, TaskQueryService queryService) {
        ((TaskInstanceServiceImpl)this.instanceService).setPm(pm);
        ((TaskInstanceServiceImpl)this.instanceService).setTaskQueryService(queryService);
        ((TaskInstanceServiceImpl)this.instanceService).setTaskEvents(((TaskServiceEntryPointImpl)this.service).getTaskLifecycleEventListeners());
    }

    protected void configureLifeCycleManager(JbpmServicesPersistenceManager pm, TaskIdentityService identityService, TaskQueryService queryService, TaskContentService contentService) {
        ((MVELLifeCycleManager)this.lifeCycleManager).setPm(pm);
        ((MVELLifeCycleManager)this.lifeCycleManager).setTaskIdentityService(identityService);
        ((MVELLifeCycleManager)this.lifeCycleManager).setTaskQueryService(queryService);
        ((MVELLifeCycleManager)this.lifeCycleManager).setTaskContentService(contentService);
        ((MVELLifeCycleManager)this.lifeCycleManager).setTaskEvents(((TaskServiceEntryPointImpl)this.service).getTaskLifecycleEventListeners());
        ((MVELLifeCycleManager)this.lifeCycleManager).initMVELOperations();
    }

    protected void configureUserGroupLifeCycleManagerDecorator(JbpmServicesPersistenceManager pm, LifeCycleManager lifeCycleManager, UserGroupCallback userGroupCallback) {
        this.userGroupLifeCycleDecorator.setManager(lifeCycleManager);
        this.userGroupLifeCycleDecorator.setPm(pm);
        this.userGroupLifeCycleDecorator.setUserGroupCallback(userGroupCallback);
    }

    protected TaskQueryService configureUserGroupQueryServiceDecorator(TaskQueryService queryService, UserGroupCallback userGroupCallback) {
        UserGroupTaskQueryServiceDecorator userGroupTaskQueryServiceDecorator = new UserGroupTaskQueryServiceDecorator();
        userGroupTaskQueryServiceDecorator.setPm(this.pm);
        userGroupTaskQueryServiceDecorator.setUserGroupCallback(userGroupCallback);
        userGroupTaskQueryServiceDecorator.setDelegate(queryService);
        return userGroupTaskQueryServiceDecorator;
    }

    protected TaskInstanceService configureUserGroupTaskInstanceServiceDecorator(TaskInstanceService instanceService, UserGroupCallback userGroupCallback) {
        UserGroupTaskInstanceServiceDecorator userGroupTaskInstanceDecorator = new UserGroupTaskInstanceServiceDecorator();
        userGroupTaskInstanceDecorator.setPm(this.pm);
        userGroupTaskInstanceDecorator.setUserGroupCallback(userGroupCallback);
        userGroupTaskInstanceDecorator.setDelegate(instanceService);
        return userGroupTaskInstanceDecorator;
    }

    protected SubTaskDecorator createSubTaskDecorator(JbpmServicesPersistenceManager pm, TaskInstanceService instanceService, TaskQueryService queryService) {
        SubTaskDecorator subTaskDecorator = new SubTaskDecorator();
        subTaskDecorator.setPm(pm);
        subTaskDecorator.setInstanceService(instanceService);
        subTaskDecorator.setQueryService(queryService);
        return subTaskDecorator;
    }

    protected DeadlinesDecorator createDeadlinesDecorator(JbpmServicesPersistenceManager pm, TaskQueryService queryService, TaskDeadlinesService deadlinesService, SubTaskDecorator subTaskDecorator) {
        DeadlinesDecorator deadlinesDecorator = new DeadlinesDecorator();
        deadlinesDecorator.setPm(pm);
        deadlinesDecorator.setQueryService(queryService);
        deadlinesDecorator.setDeadlineService(deadlinesService);
        deadlinesDecorator.setInstanceService(subTaskDecorator);
        return deadlinesDecorator;
    }

    private static class TransactionInterceptor
    implements InvocationHandler {
        private List<String> excludedMethods = new ArrayList<String>();
        private InternalTaskService delegate;
        private JbpmServicesPersistenceManager pm;

        TransactionInterceptor(InternalTaskService delegate, JbpmServicesPersistenceManager pm) {
            this.delegate = delegate;
            this.pm = pm;
            this.excludedMethods.add("addMarshallerContext");
            this.excludedMethods.add("removeMarshallerContext");
            this.excludedMethods.add("getMarshallerContext");
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] aruments) throws Throwable {
            if (!this.isTransactional(method)) {
                return method.invoke((Object)this.delegate, aruments);
            }
            boolean owner = this.pm.beginTransaction();
            try {
                Object result = method.invoke((Object)this.delegate, aruments);
                this.pm.endTransaction(owner);
                return result;
            }
            catch (Exception e) {
                if (owner) {
                    this.pm.rollBackTransaction(owner);
                }
                if (e instanceof InvocationTargetException) {
                    throw ((InvocationTargetException)e).getTargetException();
                }
                throw e;
            }
        }

        private boolean isTransactional(Method method) {
            if (method.getDeclaringClass().isAssignableFrom(EventService.class)) {
                return false;
            }
            return !this.excludedMethods.contains(method.getName());
        }
    }
}

