/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.AfterTaskAddedEvent;
import org.jbpm.services.task.events.BeforeTaskAddedEvent;
import org.jbpm.services.task.impl.model.ContentDataImpl;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalTaskData;

@Transactional
@XmlAccessorType(value=XmlAccessType.NONE)
public class AddTaskCommand
extends TaskCommand<Long> {
    @XmlElement
    private JaxbTask jaxbTask;
    private Task task;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="parameter")
    private Map<String, Object> params;
    private ContentData data;

    public AddTaskCommand() {
    }

    public AddTaskCommand(Task task, Map<String, Object> params) {
        this.setTask(task);
        this.params = params;
    }

    public AddTaskCommand(Task task, ContentData data) {
        this.setTask(task);
        this.data = data;
    }

    public Long execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        if (context.getTaskService() != null) {
            if (this.task == null) {
                this.task = this.jaxbTask;
            }
            if (this.task instanceof JaxbTask) {
                TaskImpl taskImpl = new TaskImpl();
                ArrayList<I18NText> names = new ArrayList<I18NText>();
                for (I18NText n : this.task.getNames()) {
                    names.add((I18NText)new I18NTextImpl(n.getLanguage(), n.getText()));
                }
                taskImpl.setNames(names);
                ArrayList<I18NText> descriptions = new ArrayList<I18NText>();
                for (I18NText n : this.task.getDescriptions()) {
                    descriptions.add((I18NText)new I18NTextImpl(n.getLanguage(), n.getText()));
                }
                taskImpl.setDescriptions(descriptions);
                ArrayList<I18NText> subjects = new ArrayList<I18NText>();
                for (I18NText n : this.task.getSubjects()) {
                    subjects.add((I18NText)new I18NTextImpl(n.getLanguage(), n.getText()));
                }
                taskImpl.setSubjects(subjects);
                taskImpl.setPriority(this.task.getPriority());
                TaskDataImpl taskData = new TaskDataImpl();
                taskData.setWorkItemId(this.task.getTaskData().getWorkItemId());
                taskData.setProcessInstanceId(this.task.getTaskData().getProcessInstanceId());
                taskData.setProcessId(this.task.getTaskData().getProcessId());
                taskData.setProcessSessionId(this.task.getTaskData().getProcessSessionId());
                taskData.setSkipable(this.task.getTaskData().isSkipable());
                PeopleAssignmentsImpl peopleAssignments = new PeopleAssignmentsImpl();
                ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>();
                for (OrganizationalEntity e : this.task.getPeopleAssignments().getPotentialOwners()) {
                    if (e instanceof User) {
                        potentialOwners.add((OrganizationalEntity)new UserImpl(e.getId()));
                        continue;
                    }
                    if (!(e instanceof Group)) continue;
                    potentialOwners.add((OrganizationalEntity)new GroupImpl(e.getId()));
                }
                peopleAssignments.setPotentialOwners(potentialOwners);
                ArrayList<OrganizationalEntity> businessAdmins = new ArrayList<OrganizationalEntity>();
                for (OrganizationalEntity e : this.task.getPeopleAssignments().getBusinessAdministrators()) {
                    if (e instanceof User) {
                        businessAdmins.add((OrganizationalEntity)new UserImpl(e.getId()));
                        continue;
                    }
                    if (!(e instanceof Group)) continue;
                    businessAdmins.add((OrganizationalEntity)new GroupImpl(e.getId()));
                }
                if (this.task.getPeopleAssignments().getTaskInitiator() != null) {
                    peopleAssignments.setTaskInitiator(new UserImpl(this.task.getPeopleAssignments().getTaskInitiator().getId()));
                }
                peopleAssignments.setBusinessAdministrators(businessAdmins);
                peopleAssignments.setExcludedOwners(new ArrayList<OrganizationalEntity>());
                peopleAssignments.setRecipients(new ArrayList<OrganizationalEntity>());
                peopleAssignments.setTaskStakeholders(new ArrayList<OrganizationalEntity>());
                taskImpl.setPeopleAssignments((PeopleAssignments)peopleAssignments);
                taskImpl.setTaskData((TaskData)taskData);
                if (this.data != null) {
                    return context.getTaskService().addTask((Task)taskImpl, this.data);
                }
                return context.getTaskService().addTask((Task)taskImpl, this.params);
            }
            if (this.data != null) {
                return context.getTaskService().addTask(this.task, this.data);
            }
            return context.getTaskService().addTask(this.task, this.params);
        }
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<BeforeTaskAddedEvent>(){}}).fire((Object)this.task);
        if (this.params != null) {
            ContentDataImpl contentData = ContentMarshallerHelper.marshal(this.params, null);
            ContentImpl content = new ContentImpl(contentData.getContent());
            context.getPm().persist((Object)content);
            ((InternalTaskData)this.task.getTaskData()).setDocument(content.getId(), (ContentData)contentData);
        } else if (this.data != null && this.data != null) {
            ContentImpl content = new ContentImpl(this.data.getContent());
            context.getPm().persist((Object)content);
            ((InternalTaskData)this.task.getTaskData()).setDocument(content.getId(), this.data);
        }
        context.getPm().persist((Object)this.task);
        context.getTaskEvents().select(new Annotation[]{new AnnotationLiteral<AfterTaskAddedEvent>(){}}).fire((Object)this.task);
        return this.task.getId();
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.jaxbTask = task instanceof JaxbTask ? (JaxbTask)task : new JaxbTask(task);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

