/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.evaluation;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.JBPMHelper;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class EvaluationExample {
    public static final void main(String[] args) {
        try {
            RuntimeManager manager = EvaluationExample.getRuntimeManager("evaluation/Evaluation.bpmn");
            RuntimeEngine runtime = manager.getRuntimeEngine(EmptyContext.get());
            KieSession ksession = runtime.getKieSession();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("employee", "krisv");
            params.put("reason", "Yearly performance evaluation");
            ksession.startProcess("com.sample.evaluation", params);
            TaskService taskService = runtime.getTaskService();
            List tasks = taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK");
            TaskSummary task = (TaskSummary)tasks.get(0);
            System.out.println("'krisv' completing task " + task.getName() + ": " + task.getDescription());
            taskService.start(task.getId(), "krisv");
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("performance", "exceeding");
            taskService.complete(task.getId(), "krisv", results);
            tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
            task = (TaskSummary)tasks.get(0);
            System.out.println("'john' completing task " + task.getName() + ": " + task.getDescription());
            taskService.start(task.getId(), "john");
            results = new HashMap();
            results.put("performance", "acceptable");
            taskService.complete(task.getId(), "john", results);
            tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
            task = (TaskSummary)tasks.get(0);
            System.out.println("'mary' completing task " + task.getName() + ": " + task.getDescription());
            taskService.start(task.getId(), "mary");
            results = new HashMap();
            results.put("performance", "outstanding");
            taskService.complete(task.getId(), "mary", results);
            System.out.println("Process instance completed");
            manager.disposeRuntimeEngine(runtime);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    private static RuntimeManager getRuntimeManager(String process) {
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        Properties properties = new Properties();
        properties.setProperty("krisv", "");
        properties.setProperty("mary", "");
        properties.setProperty("john", "");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        org.kie.internal.runtime.manager.RuntimeEnvironment environment = RuntimeEnvironmentBuilder.getDefault().userGroupCallback((UserGroupCallback)userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)process), ResourceType.BPMN2).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager((RuntimeEnvironment)environment);
    }
}

