/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.drools.core.audit.WorkingMemoryInMemoryLogger;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.audit.event.RuleFlowNodeLogEvent;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.kie.api.definition.process.Node;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JbpmJUnitBaseTestCase
extends Assert {
    private static final Logger logger = LoggerFactory.getLogger(JbpmJUnitBaseTestCase.class);
    protected boolean setupDataSource = false;
    protected boolean sessionPersistence = false;
    private String persistenceUnitName;
    private EntityManagerFactory emf;
    private PoolingDataSource ds;
    private TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
    private RuntimeManagerFactory managerFactory = RuntimeManagerFactory.Factory.get();
    protected RuntimeManager manager;
    private AuditLogService logService;
    private WorkingMemoryInMemoryLogger inMemoryLogger;
    protected List<RuntimeEngine> activeEngines = new ArrayList<RuntimeEngine>();

    public JbpmJUnitBaseTestCase() {
        this(false, false, "org.jbpm.persistence.jpa");
    }

    public JbpmJUnitBaseTestCase(boolean setupDataSource, boolean sessionPersistence) {
        this(setupDataSource, sessionPersistence, "org.jbpm.persistence.jpa");
    }

    public JbpmJUnitBaseTestCase(boolean setupDataSource, boolean sessionPersistence, String persistenceUnitName) {
        this.setupDataSource = setupDataSource;
        this.sessionPersistence = sessionPersistence;
        this.persistenceUnitName = persistenceUnitName;
        if (!this.setupDataSource && this.sessionPersistence) {
            throw new IllegalArgumentException("Unsupported configuration, cannot enable sessionPersistence when setupDataSource is disabled");
        }
        logger.info("Configuring entire test case to have data source enabled {} and session persistence enabled {} with persistence unit name {}", new Object[]{this.setupDataSource, this.sessionPersistence, this.persistenceUnitName});
    }

    @Before
    public void setUp() throws Exception {
        if (this.setupDataSource) {
            this.ds = this.setupPoolingDataSource();
            logger.debug("Data source configured with unique id {}", (Object)this.ds.getUniqueName());
            this.emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
        }
        JbpmJUnitBaseTestCase.cleanupSingletonSessionId();
    }

    @After
    public void tearDown() throws Exception {
        this.clearHistory();
        if (this.setupDataSource) {
            if (this.emf != null) {
                this.emf.close();
                this.emf = null;
            }
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            }
        }
        this.disposeRuntimeManager();
    }

    protected RuntimeManager createRuntimeManager(String ... process) {
        return this.createRuntimeManager(Strategy.SINGLETON, null, process);
    }

    protected RuntimeManager createRuntimeManager(Strategy strategy, String identifier, String ... process) {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        for (String p : process) {
            resources.put(p, ResourceType.BPMN2);
        }
        return this.createRuntimeManager(strategy, resources, identifier);
    }

    protected RuntimeManager createRuntimeManager(Map<String, ResourceType> resources) {
        return this.createRuntimeManager(Strategy.SINGLETON, resources, null);
    }

    protected RuntimeManager createRuntimeManager(Map<String, ResourceType> resources, String identifier) {
        return this.createRuntimeManager(Strategy.SINGLETON, resources, identifier);
    }

    protected RuntimeManager createRuntimeManager(Strategy strategy, Map<String, ResourceType> resources) {
        return this.createRuntimeManager(strategy, resources, null);
    }

    protected RuntimeManager createRuntimeManager(Strategy strategy, Map<String, ResourceType> resources, String identifier) {
        if (this.manager != null) {
            throw new IllegalStateException("There is already one RuntimeManager active");
        }
        RuntimeEnvironmentBuilder builder = null;
        builder = !this.setupDataSource ? RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().addConfiguration("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName()).addConfiguration("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName()) : (this.sessionPersistence ? RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf) : RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder());
        builder.userGroupCallback((UserGroupCallback)new JBossUserGroupCallbackImpl("classpath:/usergroups.properties"));
        for (Map.Entry<String, ResourceType> entry : resources.entrySet()) {
            builder.addAsset(ResourceFactory.newClassPathResource((String)entry.getKey()), entry.getValue());
        }
        return this.createRuntimeManager(strategy, resources, builder.get(), identifier);
    }

    protected RuntimeManager createRuntimeManager(Strategy strategy, Map<String, ResourceType> resources, RuntimeEnvironment environment, String identifier) {
        if (this.manager != null) {
            throw new IllegalStateException("There is already one RuntimeManager active");
        }
        switch (strategy) {
            case SINGLETON: {
                if (identifier == null) {
                    this.manager = this.managerFactory.newSingletonRuntimeManager(environment);
                    break;
                }
                this.manager = this.managerFactory.newSingletonRuntimeManager(environment, identifier);
                break;
            }
            case REQUEST: {
                if (identifier == null) {
                    this.manager = this.managerFactory.newPerRequestRuntimeManager(environment);
                    break;
                }
                this.manager = this.managerFactory.newPerRequestRuntimeManager(environment, identifier);
                break;
            }
            case PROCESS_INSTANCE: {
                if (identifier == null) {
                    this.manager = this.managerFactory.newPerProcessInstanceRuntimeManager(environment);
                    break;
                }
                this.manager = this.managerFactory.newPerProcessInstanceRuntimeManager(environment, identifier);
                break;
            }
            default: {
                this.manager = identifier == null ? this.managerFactory.newSingletonRuntimeManager(environment) : this.managerFactory.newSingletonRuntimeManager(environment, identifier);
            }
        }
        return this.manager;
    }

    protected void disposeRuntimeManager() {
        if (!this.activeEngines.isEmpty()) {
            for (RuntimeEngine engine : this.activeEngines) {
                this.manager.disposeRuntimeEngine(engine);
            }
            this.activeEngines.clear();
        }
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    protected RuntimeEngine getRuntimeEngine() {
        return this.getRuntimeEngine(EmptyContext.get());
    }

    protected RuntimeEngine getRuntimeEngine(Context<?> context) {
        if (this.manager == null) {
            throw new IllegalStateException("RuntimeManager is not initialized, did you forgot to create it?");
        }
        RuntimeEngine runtimeEngine = this.manager.getRuntimeEngine(context);
        this.activeEngines.add(runtimeEngine);
        if (this.sessionPersistence) {
            this.logService = new JPAAuditLogService(runtimeEngine.getKieSession().getEnvironment());
        } else {
            this.inMemoryLogger = new WorkingMemoryInMemoryLogger((KnowledgeRuntimeEventManager)((StatefulKnowledgeSession)runtimeEngine.getKieSession()));
        }
        return runtimeEngine;
    }

    public Object getVariableValue(String name, long processInstanceId, KieSession ksession) {
        return ((WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId)).getVariable(name);
    }

    public void assertProcessInstanceCompleted(long processInstanceId, KieSession ksession) {
        JbpmJUnitBaseTestCase.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceAborted(long processInstanceId, KieSession ksession) {
        JbpmJUnitBaseTestCase.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceActive(long processInstanceId, KieSession ksession) {
        JbpmJUnitBaseTestCase.assertNotNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertNodeActive(long processInstanceId, KieSession ksession, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance instanceof WorkflowProcessInstance) {
            this.assertNodeActive((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), names);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitBaseTestCase.fail((String)("Node(s) not active: " + s));
        }
    }

    private void assertNodeActive(NodeInstanceContainer container, List<String> names) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.assertNodeActive((NodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(long processInstanceId, String ... nodeNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : nodeNames) {
            names.add(nodeName);
        }
        if (this.sessionPersistence) {
            List logs = this.logService.findNodeInstances(processInstanceId);
            if (logs != null) {
                for (NodeInstanceLog l : logs) {
                    String nodeName;
                    nodeName = l.getNodeName();
                    if (l.getType() != 0 && l.getType() != 1 || !names.contains(nodeName)) continue;
                    names.remove(nodeName);
                }
            }
        } else {
            for (LogEvent event : this.inMemoryLogger.getLogEvents()) {
                String nodeName;
                if (!(event instanceof RuleFlowNodeLogEvent) || !names.contains(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
                names.remove(nodeName);
            }
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitBaseTestCase.fail((String)("Node(s) not executed: " + s));
        }
    }

    public void assertProcessVarExists(ProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitBaseTestCase.fail((String)("Process Variable(s) do not exist: " + s));
        }
    }

    public void assertNodeExists(ProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitBaseTestCase.fail((String)("Node(s) do not exist: " + s));
        }
    }

    public void assertNumOfIncommingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            JbpmJUnitBaseTestCase.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            JbpmJUnitBaseTestCase.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(ProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            JbpmJUnitBaseTestCase.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(ProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            JbpmJUnitBaseTestCase.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(ProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            JbpmJUnitBaseTestCase.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    protected EntityManagerFactory getEmf() {
        return this.emf;
    }

    protected DataSource getDs() {
        return this.ds;
    }

    protected PoolingDataSource setupPoolingDataSource() {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName("jdbc/jbpm-ds");
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        pds.setMaxPoolSize(5);
        pds.setAllowLocalTransactions(true);
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("password", "");
        pds.getDriverProperties().put("url", "jdbc:h2:mem:jbpm-db;MVCC=true");
        pds.getDriverProperties().put("driverClassName", "org.h2.Driver");
        pds.init();
        return pds;
    }

    protected void clearHistory() {
        if (this.sessionPersistence && this.logService != null) {
            this.logService.clear();
        } else if (this.inMemoryLogger != null) {
            this.inMemoryLogger.clear();
        }
    }

    protected TestWorkItemHandler getTestWorkItemHandler() {
        return this.workItemHandler;
    }

    protected AuditLogService getLogService() {
        return this.logService;
    }

    protected WorkingMemoryInMemoryLogger getInMemoryLogger() {
        return this.inMemoryLogger;
    }

    protected static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }

    protected static class TestWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        protected TestWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            if (this.workItems.size() == 0) {
                return null;
            }
            if (this.workItems.size() == 1) {
                WorkItem result = this.workItems.get(0);
                this.workItems.clear();
                return result;
            }
            throw new IllegalArgumentException("More than one work item active");
        }

        public List<WorkItem> getWorkItems() {
            ArrayList<WorkItem> result = new ArrayList<WorkItem>(this.workItems);
            this.workItems.clear();
            return result;
        }
    }

    public static enum Strategy {
        SINGLETON,
        REQUEST,
        PROCESS_INSTANCE;

    }
}

