/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.command.AbstractHistoryLogCommand;
import org.kie.internal.command.Context;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FindNodeInstancesCommand
extends AbstractHistoryLogCommand<List<NodeInstanceLog>> {
    private static final long serialVersionUID = 5374910016873481604L;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="long")
    private Long processInstanceId;
    @XmlAttribute
    @XmlSchemaType(name="string")
    private String nodeId;

    public FindNodeInstancesCommand() {
    }

    public FindNodeInstancesCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.nodeId = null;
    }

    public FindNodeInstancesCommand(long processInstanceId, String nodeId) {
        this.processInstanceId = processInstanceId;
        this.nodeId = nodeId;
        if (nodeId == null || nodeId.isEmpty()) {
            throw new IllegalArgumentException("The nodeId field must not be null or empty.");
        }
    }

    public List<NodeInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            return this.auditLogService.findNodeInstances(this.processInstanceId);
        }
        return this.auditLogService.findNodeInstances(this.processInstanceId, this.nodeId);
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String toString() {
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            return AuditLogService.class.getSimpleName() + ".findNodeInstances(" + this.processInstanceId + ")";
        }
        return AuditLogService.class.getSimpleName() + ".findNodeInstances(" + this.processInstanceId + ", " + this.nodeId + ")";
    }
}

