/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.InternalRuntimeManager;

public class RuntimeManagerRegistry {
    private Map<String, RuntimeManager> registry = new ConcurrentHashMap<String, RuntimeManager>();
    private static RuntimeManagerRegistry instance;

    protected RuntimeManagerRegistry() {
    }

    public static RuntimeManagerRegistry get() {
        if (instance == null) {
            instance = new RuntimeManagerRegistry();
        }
        return instance;
    }

    public void addRuntimeManager(String id, RuntimeManager manager) {
        RuntimeManager cachedManager = this.registry.get(id);
        if (cachedManager != null && !((InternalRuntimeManager)cachedManager).isClosed()) {
            throw new IllegalStateException("RuntimeManager with id " + id + " is already registered");
        }
        this.registry.put(id, manager);
    }

    public void remove(String id) {
        this.registry.remove(id);
    }

    public RuntimeManager getRuntimeManager(String id) {
        return this.registry.get(id);
    }
}

