/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import org.jboss.weld.context.AbstractContext;
import org.jboss.weld.context.ManagedContext;

public abstract class AbstractManagedContext
extends AbstractContext
implements ManagedContext {
    private final ThreadLocal<Boolean> active = new ThreadLocal();
    private final ThreadLocal<Boolean> valid = new ThreadLocal();

    public AbstractManagedContext(boolean multithreaded) {
        super(multithreaded);
    }

    public boolean isActive() {
        Boolean active = this.active.get();
        return active == null ? false : active;
    }

    protected void setActive(boolean active) {
        this.active.set(active);
    }

    public void invalidate() {
        this.valid.set(Boolean.FALSE);
    }

    public void activate() {
        this.setActive(true);
    }

    private boolean isValid() {
        Boolean valid = this.valid.get();
        return valid == null ? true : valid;
    }

    public void deactivate() {
        if (!this.isValid()) {
            this.destroy();
        }
        this.active.remove();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.active.remove();
        this.valid.remove();
    }
}

