/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.jbpm.kie.services.api.DeployedUnit;
import org.jbpm.kie.services.api.DeploymentService;
import org.jbpm.kie.services.api.DeploymentUnit;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.event.Deploy;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeploymentService
implements DeploymentService {
    private static Logger logger = LoggerFactory.getLogger(AbstractDeploymentService.class);
    @Inject
    private RuntimeManagerFactory managerFactory;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private EntityManagerFactory emf;
    @Inject
    @Deploy
    protected Event<DeploymentEvent> deploymentEvent;
    @Inject
    @Undeploy
    protected Event<DeploymentEvent> undeploymentEvent;
    protected Map<String, DeployedUnit> deploymentsMap = new ConcurrentHashMap<String, DeployedUnit>();

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Override
    public void deploy(DeploymentUnit unit) {
        if (this.deploymentsMap.containsKey(unit.getIdentifier())) {
            throw new IllegalStateException("Unit with id " + unit.getIdentifier() + " is already deployed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commonDeploy(DeploymentUnit unit, DeployedUnitImpl deployedUnit, RuntimeEnvironment environemnt) {
        AbstractDeploymentService abstractDeploymentService = this;
        synchronized (abstractDeploymentService) {
            if (this.deploymentsMap.containsKey(unit.getIdentifier())) {
                DeployedUnit deployed = this.deploymentsMap.remove(unit.getIdentifier());
                RuntimeManager manager = deployed.getRuntimeManager();
                manager.close();
            }
            RuntimeManager manager = null;
            this.deploymentsMap.put(unit.getIdentifier(), deployedUnit);
            try {
                switch (unit.getStrategy()) {
                    case SINGLETON: {
                        manager = this.managerFactory.newSingletonRuntimeManager(environemnt, unit.getIdentifier());
                        break;
                    }
                    case PER_REQUEST: {
                        manager = this.managerFactory.newPerRequestRuntimeManager(environemnt, unit.getIdentifier());
                        break;
                    }
                    case PER_PROCESS_INSTANCE: {
                        manager = this.managerFactory.newPerProcessInstanceRuntimeManager(environemnt, unit.getIdentifier());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid strategy " + (Object)((Object)unit.getStrategy()));
                    }
                }
                deployedUnit.setRuntimeManager(manager);
            }
            catch (Exception e) {
                this.deploymentsMap.remove(unit.getIdentifier());
                throw new RuntimeException(e);
            }
        }
        if (this.deploymentEvent != null) {
            this.deploymentEvent.fire((Object)new DeploymentEvent(unit.getIdentifier(), deployedUnit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(DeploymentUnit unit) {
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(1);
        states.add(0);
        states.add(4);
        Collection<ProcessInstanceDesc> activeProcesses = this.runtimeDataService.getProcessInstancesByDeploymentId(unit.getIdentifier(), states);
        if (!activeProcesses.isEmpty()) {
            throw new IllegalStateException("Undeploy forbidden - there are active processes instances for deployment " + unit.getIdentifier());
        }
        AbstractDeploymentService abstractDeploymentService = this;
        synchronized (abstractDeploymentService) {
            DeployedUnit deployed = this.deploymentsMap.remove(unit.getIdentifier());
            if (deployed != null) {
                RuntimeManager manager = deployed.getRuntimeManager();
                ((AbstractRuntimeManager)manager).close(true);
            }
            if (this.undeploymentEvent != null) {
                this.undeploymentEvent.fire((Object)new DeploymentEvent(unit.getIdentifier(), deployed));
            }
        }
    }

    @Override
    public RuntimeManager getRuntimeManager(String deploymentUnitId) {
        if (this.deploymentsMap.containsKey(deploymentUnitId)) {
            return this.deploymentsMap.get(deploymentUnitId).getRuntimeManager();
        }
        return null;
    }

    @Override
    public DeployedUnit getDeployedUnit(String deploymentUnitId) {
        if (this.deploymentsMap.containsKey(deploymentUnitId)) {
            return this.deploymentsMap.get(deploymentUnitId);
        }
        return null;
    }

    public Map<String, DeployedUnit> getDeploymentsMap() {
        return this.deploymentsMap;
    }

    @Override
    public Collection<DeployedUnit> getDeployedUnits() {
        return Collections.unmodifiableCollection(this.deploymentsMap.values());
    }

    public RuntimeManagerFactory getManagerFactory() {
        return this.managerFactory;
    }

    public void setManagerFactory(RuntimeManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public RuntimeDataService getRuntimeDataService() {
        return this.runtimeDataService;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    protected AbstractAuditLogger getAuditLogger() {
        if ("true".equals(System.getProperty("jbpm.audit.jms.enabled"))) {
            try {
                Properties properties = new Properties();
                properties.load(this.getClass().getResourceAsStream("/jbpm.audit.jms.properties"));
                return AuditLoggerFactory.newJMSInstance((Map)properties);
            }
            catch (IOException e) {
                logger.error("Unable to load jms audit properties from {}", (Object)"/jbpm.audit.jms.properties", (Object)e);
            }
        }
        return AuditLoggerFactory.newJPAInstance((EntityManagerFactory)this.getEmf());
    }
}

