/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.stackmap.MapMaker;
import javax.persistence.Transient;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.EnhancementException;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class Enhancer {
    private static final CoreMessageLogger log = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Enhancer.class.getName());
    public static final String PERSISTENT_FIELD_READER_PREFIX = "$$_hibernate_read_";
    public static final String PERSISTENT_FIELD_WRITER_PREFIX = "$$_hibernate_write_";
    public static final String ENTITY_INSTANCE_GETTER_NAME = "$$_hibernate_getEntityInstance";
    public static final String ENTITY_ENTRY_FIELD_NAME = "$$_hibernate_entityEntryHolder";
    public static final String ENTITY_ENTRY_GETTER_NAME = "$$_hibernate_getEntityEntry";
    public static final String ENTITY_ENTRY_SETTER_NAME = "$$_hibernate_setEntityEntry";
    public static final String PREVIOUS_FIELD_NAME = "$$_hibernate_previousManagedEntity";
    public static final String PREVIOUS_GETTER_NAME = "$$_hibernate_getPreviousManagedEntity";
    public static final String PREVIOUS_SETTER_NAME = "$$_hibernate_setPreviousManagedEntity";
    public static final String NEXT_FIELD_NAME = "$$_hibernate_nextManagedEntity";
    public static final String NEXT_GETTER_NAME = "$$_hibernate_getNextManagedEntity";
    public static final String NEXT_SETTER_NAME = "$$_hibernate_setNextManagedEntity";
    public static final String INTERCEPTOR_FIELD_NAME = "$$_hibernate_attributeInterceptor";
    public static final String INTERCEPTOR_GETTER_NAME = "$$_hibernate_getInterceptor";
    public static final String INTERCEPTOR_SETTER_NAME = "$$_hibernate_setInterceptor";
    private final EnhancementContext enhancementContext;
    private final ClassPool classPool;
    private final CtClass managedEntityCtClass;
    private final CtClass managedCompositeCtClass;
    private final CtClass attributeInterceptorCtClass;
    private final CtClass attributeInterceptableCtClass;
    private final CtClass entityEntryCtClass;
    private final CtClass objectCtClass;
    private static final AttributeTypeDescriptor BOOLEAN_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readBoolean(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("boolean localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeBoolean(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor BYTE_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readByte(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("byte localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeByte(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor CHAR_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readChar(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("char localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeChar(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor SHORT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readShort(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("short localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeShort(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor INT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readInt(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("int localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeInt(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor LONG_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readLong(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("long localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeLong(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor DOUBLE_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readDouble(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("double localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeDouble(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };
    private static final AttributeTypeDescriptor FLOAT_DESCRIPTOR = new AbstractAttributeTypeDescriptor(){

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = $$_hibernate_getInterceptor().readFloat(this, \"%1$s\", this.%1$s); }", fieldName);
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("float localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = $$_hibernate_getInterceptor().writeFloat(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName);
        }
    };

    public Enhancer(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
        this.classPool = this.buildClassPool(enhancementContext);
        try {
            this.managedEntityCtClass = this.classPool.makeClass(ManagedEntity.class.getClassLoader().getResourceAsStream(ManagedEntity.class.getName().replace('.', '/') + ".class"));
            this.managedCompositeCtClass = this.classPool.makeClass(ManagedComposite.class.getClassLoader().getResourceAsStream(ManagedComposite.class.getName().replace('.', '/') + ".class"));
            this.attributeInterceptableCtClass = this.classPool.makeClass(PersistentAttributeInterceptable.class.getClassLoader().getResourceAsStream(PersistentAttributeInterceptable.class.getName().replace('.', '/') + ".class"));
            this.attributeInterceptorCtClass = this.classPool.makeClass(PersistentAttributeInterceptor.class.getClassLoader().getResourceAsStream(PersistentAttributeInterceptor.class.getName().replace('.', '/') + ".class"));
            this.entityEntryCtClass = this.classPool.makeClass(EntityEntry.class.getName());
        }
        catch (IOException e) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", e);
        }
        try {
            this.objectCtClass = this.classPool.getCtClass(Object.class.getName());
        }
        catch (NotFoundException e) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", e);
        }
    }

    private ClassPool buildClassPool(EnhancementContext enhancementContext) {
        ClassPool classPool = new ClassPool(false);
        ClassLoader loadingClassLoader = enhancementContext.getLoadingClassLoader();
        if (loadingClassLoader != null) {
            classPool.appendClassPath((ClassPath)new LoaderClassPath(loadingClassLoader));
        }
        return classPool;
    }

    public byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        CtClass managedCtClass;
        try {
            managedCtClass = this.classPool.makeClassIfNew((InputStream)new ByteArrayInputStream(originalBytes));
        }
        catch (IOException e) {
            log.unableToBuildEnhancementMetamodel(className);
            return originalBytes;
        }
        this.enhance(managedCtClass);
        FilterOutputStream out = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            out = new DataOutputStream(byteStream);
            managedCtClass.toBytecode((DataOutputStream)out);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.unableToTransformClass(e.getMessage());
            throw new HibernateException("Unable to transform class: " + e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void enhance(CtClass managedCtClass) {
        String[] interfaceNames;
        String className = managedCtClass.getName();
        log.debugf("Enhancing %s", className);
        if (managedCtClass.isInterface()) {
            log.debug("skipping enhancement : interface");
            return;
        }
        for (String interfaceName : interfaceNames = managedCtClass.getClassFile2().getInterfaces()) {
            if (!ManagedEntity.class.getName().equals(interfaceName) && !ManagedComposite.class.getName().equals(interfaceName)) continue;
            log.debug("skipping enhancement : already enhanced");
            return;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            this.enhanceAsEntity(managedCtClass);
        } else if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            this.enhanceAsComposite(managedCtClass);
        } else {
            log.debug("skipping enhancement : not entity or composite");
        }
    }

    private void enhanceAsEntity(CtClass managedCtClass) {
        managedCtClass.addInterface(this.managedEntityCtClass);
        this.enhancePersistentAttributes(managedCtClass);
        this.addEntityInstanceHandling(managedCtClass);
        this.addEntityEntryHandling(managedCtClass);
        this.addLinkedPreviousHandling(managedCtClass);
        this.addLinkedNextHandling(managedCtClass);
    }

    private void enhanceAsComposite(CtClass managedCtClass) {
        this.enhancePersistentAttributes(managedCtClass);
    }

    private void addEntityInstanceHandling(CtClass managedCtClass) {
        try {
            managedCtClass.addMethod(CtNewMethod.make((CtClass)this.objectCtClass, (String)ENTITY_INSTANCE_GETTER_NAME, (CtClass[])new CtClass[0], (CtClass[])new CtClass[0], (String)"{ return this; }", (CtClass)managedCtClass));
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add EntityEntry getter", managedCtClass.getName()), e);
        }
    }

    private void addEntityEntryHandling(CtClass managedCtClass) {
        this.addFieldWithGetterAndSetter(managedCtClass, this.entityEntryCtClass, ENTITY_ENTRY_FIELD_NAME, ENTITY_ENTRY_GETTER_NAME, ENTITY_ENTRY_SETTER_NAME);
    }

    private void addLinkedPreviousHandling(CtClass managedCtClass) {
        this.addFieldWithGetterAndSetter(managedCtClass, this.managedEntityCtClass, PREVIOUS_FIELD_NAME, PREVIOUS_GETTER_NAME, PREVIOUS_SETTER_NAME);
    }

    private void addLinkedNextHandling(CtClass managedCtClass) {
        this.addFieldWithGetterAndSetter(managedCtClass, this.managedEntityCtClass, NEXT_FIELD_NAME, NEXT_GETTER_NAME, NEXT_SETTER_NAME);
    }

    private AnnotationsAttribute getVisibleAnnotations(FieldInfo fieldInfo) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(fieldInfo.getConstPool(), "RuntimeVisibleAnnotations");
            fieldInfo.addAttribute((AttributeInfo)annotationsAttribute);
        }
        return annotationsAttribute;
    }

    private void enhancePersistentAttributes(CtClass managedCtClass) {
        this.addInterceptorHandling(managedCtClass);
        if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
            this.addInLineDirtyHandling(managedCtClass);
        }
        IdentityHashMap<String, PersistentAttributeDescriptor> attrDescriptorMap = new IdentityHashMap<String, PersistentAttributeDescriptor>();
        for (CtField persistentField : this.collectPersistentFields(managedCtClass)) {
            attrDescriptorMap.put(persistentField.getName(), this.enhancePersistentAttribute(managedCtClass, persistentField));
        }
        this.transformFieldAccessesIntoReadsAndWrites(managedCtClass, attrDescriptorMap);
    }

    private PersistentAttributeDescriptor enhancePersistentAttribute(CtClass managedCtClass, CtField persistentField) {
        try {
            AttributeTypeDescriptor typeDescriptor = this.resolveAttributeTypeDescriptor(persistentField);
            return new PersistentAttributeDescriptor(persistentField, this.generateFieldReader(managedCtClass, persistentField, typeDescriptor), this.generateFieldWriter(managedCtClass, persistentField, typeDescriptor), typeDescriptor);
        }
        catch (Exception e) {
            throw new EnhancementException(String.format("Unable to enhance persistent attribute [%s:%s]", managedCtClass.getName(), persistentField.getName()), e);
        }
    }

    private CtField[] collectPersistentFields(CtClass managedCtClass) {
        ArrayList<CtField> persistentFieldList = new ArrayList<CtField>();
        for (CtField ctField : managedCtClass.getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers()) || ctField.getName().startsWith("$") || !this.enhancementContext.isPersistentField(ctField)) continue;
            persistentFieldList.add(ctField);
        }
        return this.enhancementContext.order(persistentFieldList.toArray(new CtField[persistentFieldList.size()]));
    }

    private void addInterceptorHandling(CtClass managedCtClass) {
        if (this.enhancementContext.doDirtyCheckingInline(managedCtClass) && !this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            return;
        }
        log.debug("Weaving in PersistentAttributeInterceptable implementation");
        managedCtClass.addInterface(this.attributeInterceptableCtClass);
        this.addFieldWithGetterAndSetter(managedCtClass, this.attributeInterceptorCtClass, INTERCEPTOR_FIELD_NAME, INTERCEPTOR_GETTER_NAME, INTERCEPTOR_SETTER_NAME);
    }

    private void addInLineDirtyHandling(CtClass managedCtClass) {
    }

    private void addFieldWithGetterAndSetter(CtClass targetClass, CtClass fieldType, String fieldName, String getterName, String setterName) {
        CtField theField = this.addField(targetClass, fieldType, fieldName, true);
        this.addGetter(targetClass, theField, getterName);
        this.addSetter(targetClass, theField, setterName);
    }

    private CtField addField(CtClass targetClass, CtClass fieldType, String fieldName, boolean makeTransient) {
        CtField theField;
        ConstPool constPool = targetClass.getClassFile().getConstPool();
        try {
            theField = new CtField(fieldType, fieldName, targetClass);
            targetClass.addField(theField);
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance class [%s] to add field [%s]", targetClass.getName(), fieldName), e);
        }
        if (makeTransient) {
            theField.setModifiers(theField.getModifiers() | 0x80);
        }
        theField.setModifiers(Modifier.setPrivate((int)theField.getModifiers()));
        AnnotationsAttribute annotationsAttribute = this.getVisibleAnnotations(theField.getFieldInfo());
        annotationsAttribute.addAnnotation(new Annotation(Transient.class.getName(), constPool));
        return theField;
    }

    private void addGetter(CtClass targetClass, CtField theField, String getterName) {
        try {
            targetClass.addMethod(CtNewMethod.getter((String)getterName, (CtField)theField));
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add getter method [%s]", targetClass.getName(), getterName), e);
        }
    }

    private void addSetter(CtClass targetClass, CtField theField, String setterName) {
        try {
            targetClass.addMethod(CtNewMethod.setter((String)setterName, (CtField)theField));
        }
        catch (CannotCompileException e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add setter method [%s]", targetClass.getName(), setterName), e);
        }
    }

    private CtMethod generateFieldReader(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) throws BadBytecode, CannotCompileException {
        FieldInfo fieldInfo = persistentField.getFieldInfo();
        String fieldName = fieldInfo.getName();
        String readerName = PERSISTENT_FIELD_READER_PREFIX + fieldName;
        if (!this.enhancementContext.isLazyLoadable(persistentField)) {
            try {
                CtMethod reader = CtNewMethod.getter((String)readerName, (CtField)persistentField);
                managedCtClass.addMethod(reader);
                return reader;
            }
            catch (CannotCompileException e) {
                throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName), e);
            }
        }
        String methodBody = typeDescriptor.buildReadInterceptionBodyFragment(fieldName) + " return this." + fieldName + ";";
        try {
            CtMethod reader = CtNewMethod.make((int)2, (CtClass)persistentField.getType(), (String)readerName, null, null, (String)("{" + methodBody + "}"), (CtClass)managedCtClass);
            managedCtClass.addMethod(reader);
            return reader;
        }
        catch (Exception e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName), e);
        }
    }

    private CtMethod generateFieldWriter(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        FieldInfo fieldInfo = persistentField.getFieldInfo();
        String fieldName = fieldInfo.getName();
        String writerName = PERSISTENT_FIELD_WRITER_PREFIX + fieldName;
        try {
            CtMethod writer;
            if (!this.enhancementContext.isLazyLoadable(persistentField)) {
                writer = CtNewMethod.setter((String)writerName, (CtField)persistentField);
            } else {
                String methodBody = typeDescriptor.buildWriteInterceptionBodyFragment(fieldName);
                writer = CtNewMethod.make((int)2, (CtClass)CtClass.voidType, (String)writerName, (CtClass[])new CtClass[]{persistentField.getType()}, null, (String)("{" + methodBody + "}"), (CtClass)managedCtClass);
            }
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                writer.insertBefore(typeDescriptor.buildInLineDirtyCheckingBodyFragment(fieldName));
            }
            managedCtClass.addMethod(writer);
            return writer;
        }
        catch (Exception e) {
            throw new EnhancementException(String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName), e);
        }
    }

    private void transformFieldAccessesIntoReadsAndWrites(CtClass managedCtClass, IdentityHashMap<String, PersistentAttributeDescriptor> attributeDescriptorMap) {
        ConstPool constPool = managedCtClass.getClassFile().getConstPool();
        for (Object oMethod : managedCtClass.getClassFile().getMethods()) {
            CodeAttribute codeAttr;
            MethodInfo methodInfo = (MethodInfo)oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith(PERSISTENT_FIELD_READER_PREFIX) || methodName.startsWith(PERSISTENT_FIELD_WRITER_PREFIX) || methodName.equals(ENTITY_INSTANCE_GETTER_NAME) || methodName.equals(ENTITY_ENTRY_GETTER_NAME) || methodName.equals(ENTITY_ENTRY_SETTER_NAME) || methodName.equals(PREVIOUS_GETTER_NAME) || methodName.equals(PREVIOUS_SETTER_NAME) || methodName.equals(NEXT_GETTER_NAME) || methodName.equals(NEXT_SETTER_NAME) || (codeAttr = methodInfo.getCodeAttribute()) == null) continue;
            try {
                CodeIterator itr = codeAttr.iterator();
                while (itr.hasNext()) {
                    int constIndex;
                    String fieldName;
                    PersistentAttributeDescriptor attributeDescriptor;
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180 || (attributeDescriptor = attributeDescriptorMap.get(fieldName = constPool.getFieldrefName(constIndex = itr.u16bitAt(index + 1)))) == null) continue;
                    log.tracef("Transforming access to field [%s] from method [%s]", fieldName, methodName);
                    if (op == 180) {
                        int read_method_index = constPool.addMethodrefInfo(constPool.getThisClassInfo(), attributeDescriptor.getReader().getName(), attributeDescriptor.getReader().getSignature());
                        itr.writeByte(183, index);
                        itr.write16bit(read_method_index, index + 1);
                        continue;
                    }
                    int write_method_index = constPool.addMethodrefInfo(constPool.getThisClassInfo(), attributeDescriptor.getWriter().getName(), attributeDescriptor.getWriter().getSignature());
                    itr.writeByte(183, index);
                    itr.write16bit(write_method_index, index + 1);
                }
                StackMapTable smt = MapMaker.make((ClassPool)this.classPool, (MethodInfo)methodInfo);
                methodInfo.getCodeAttribute().setAttribute(smt);
            }
            catch (BadBytecode e) {
                throw new EnhancementException("Unable to perform field access transformation in method : " + methodName, e);
            }
        }
    }

    private AttributeTypeDescriptor resolveAttributeTypeDescriptor(CtField persistentField) throws NotFoundException {
        if (persistentField.getType() == CtClass.booleanType) {
            return BOOLEAN_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.byteType) {
            return BYTE_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.charType) {
            return CHAR_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.shortType) {
            return SHORT_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.intType) {
            return INT_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.longType) {
            return LONG_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.doubleType) {
            return DOUBLE_DESCRIPTOR;
        }
        if (persistentField.getType() == CtClass.floatType) {
            return FLOAT_DESCRIPTOR;
        }
        return new ObjectAttributeTypeDescriptor(persistentField.getType());
    }

    private static class ObjectAttributeTypeDescriptor
    extends AbstractAttributeTypeDescriptor {
        private final CtClass concreteType;

        private ObjectAttributeTypeDescriptor(CtClass concreteType) {
            this.concreteType = concreteType;
        }

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("if ( $$_hibernate_getInterceptor() != null ) { this.%1$s = (%2$s) $$_hibernate_getInterceptor().readObject(this, \"%1$s\", this.%1$s); }", fieldName, this.concreteType.getName());
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("%2$s localVar = $1;if ( $$_hibernate_getInterceptor() != null ) {localVar = (%2$s) $$_hibernate_getInterceptor().writeObject(this, \"%1$s\", this.%1$s, $1);}this.%1$s = localVar;", fieldName, this.concreteType.getName());
        }
    }

    private static abstract class AbstractAttributeTypeDescriptor
    implements AttributeTypeDescriptor {
        private AbstractAttributeTypeDescriptor() {
        }

        @Override
        public String buildInLineDirtyCheckingBodyFragment(String fieldName) {
            return String.format("System.out.println( \"DIRTY CHECK (%1$s) : \" + this.%1$s + \" -> \" + $1 + \" (dirty=\" + (this.%1$s != $1) +\")\" );", fieldName);
        }
    }

    private static interface AttributeTypeDescriptor {
        public String buildReadInterceptionBodyFragment(String var1);

        public String buildWriteInterceptionBodyFragment(String var1);

        public String buildInLineDirtyCheckingBodyFragment(String var1);
    }

    private static class PersistentAttributeDescriptor {
        private final CtField field;
        private final CtMethod reader;
        private final CtMethod writer;
        private final AttributeTypeDescriptor typeDescriptor;

        private PersistentAttributeDescriptor(CtField field, CtMethod reader, CtMethod writer, AttributeTypeDescriptor typeDescriptor) {
            this.field = field;
            this.reader = reader;
            this.writer = writer;
            this.typeDescriptor = typeDescriptor;
        }

        public CtField getField() {
            return this.field;
        }

        public CtMethod getReader() {
            return this.reader;
        }

        public CtMethod getWriter() {
            return this.writer;
        }

        public AttributeTypeDescriptor getTypeDescriptor() {
            return this.typeDescriptor;
        }
    }
}

