/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.kie.services.api.Kjar;
import org.jbpm.kie.services.api.bpmn2.BPMN2DataService;
import org.jbpm.kie.services.impl.AbstractDeploymentService;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.cdi.InjectableRegisterableItemsFactory;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.internal.deployment.DeploymentUnit;
import org.kie.scanner.MavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Kjar
public class KModuleDeploymentService
extends AbstractDeploymentService {
    private static Logger logger = LoggerFactory.getLogger(KModuleDeploymentService.class);
    private static final String DEFAULT_KBASE_NAME = "defaultKieBase";
    @Inject
    private BeanManager beanManager;
    @Inject
    private IdentityProvider identityProvider;
    @Inject
    private BPMN2DataService bpmn2Service;

    @Override
    public void deploy(DeploymentUnit unit) {
        InternalKieModule module;
        super.deploy(unit);
        if (!(unit instanceof KModuleDeploymentUnit)) {
            throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
        }
        KModuleDeploymentUnit kmoduleUnit = (KModuleDeploymentUnit)unit;
        DeployedUnitImpl deployedUnit = new DeployedUnitImpl(unit);
        KieServices ks = KieServices.Factory.get();
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.resolveArtifact(kmoduleUnit.getIdentifier());
        ReleaseId releaseId = ks.newReleaseId(kmoduleUnit.getGroupId(), kmoduleUnit.getArtifactId(), kmoduleUnit.getVersion());
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        String kbaseName = kmoduleUnit.getKbaseName();
        if (StringUtils.isEmpty((CharSequence)kbaseName)) {
            KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
            kbaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
        }
        if ((module = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kbaseName)) == null) {
            throw new IllegalStateException("Cannot find kbase with name " + kbaseName);
        }
        HashMap<String, String> formsData = new HashMap<String, String>();
        Collection files = module.getFileNames();
        for (String fileName : files) {
            String key;
            Matcher m;
            Pattern regex;
            String formContent;
            if (fileName.matches(".+bpmn[2]?$")) {
                try {
                    String processString = new String(module.getBytes(fileName), "UTF-8");
                    ProcessAssetDesc process = this.bpmn2Service.findProcessId(processString, kieContainer.getClassLoader());
                    process.setEncodedProcessSource(Base64.encodeBase64String((byte[])processString.getBytes()));
                    process.setDeploymentId(unit.getIdentifier());
                    process.setForms(formsData);
                    deployedUnit.addAssetLocation(process.getId(), process);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("Unable to load content for file '{}' : {}", (Object)fileName, (Object)e);
                }
                continue;
            }
            if (fileName.matches(".+ftl$")) {
                try {
                    formContent = new String(module.getBytes(fileName), "UTF-8");
                    regex = Pattern.compile("(.{0}|.*/)([^/]*?)\\.ftl");
                    m = regex.matcher(fileName);
                    key = fileName;
                    while (m.find()) {
                        key = m.group(2);
                    }
                    formsData.put(key, formContent);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("Unable to load content for form '{}' : {}", (Object)fileName, (Object)e);
                }
                continue;
            }
            if (fileName.matches(".+form$")) {
                try {
                    formContent = new String(module.getBytes(fileName), "UTF-8");
                    regex = Pattern.compile("(.{0}|.*/)([^/]*?)\\.form");
                    m = regex.matcher(fileName);
                    key = fileName;
                    while (m.find()) {
                        key = m.group(2);
                    }
                    formsData.put(key + ".form", formContent);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("Unable to load content for form '{}' : {}", (Object)fileName, (Object)e);
                }
                continue;
            }
            if (!fileName.matches(".+class$")) continue;
            String className = fileName.replaceAll("/", ".");
            className = className.substring(0, fileName.length() - ".class".length());
            try {
                deployedUnit.addClass(kieContainer.getClassLoader().loadClass(className));
                logger.debug("Loaded {} into the classpath from deployment {}", (Object)className, (Object)releaseId.toExternalForm());
            }
            catch (ClassNotFoundException cnfe) {
                logger.error("Unable to load {} when deploying {}", new Object[]{className, releaseId.toExternalForm(), cnfe});
            }
        }
        KieBase kbase = kieContainer.getKieBase(kbaseName);
        AbstractAuditLogger auditLogger = this.getAuditLogger();
        ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
        auditEventBuilder.setIdentityProvider(this.identityProvider);
        auditEventBuilder.setDeploymentUnitId(unit.getIdentifier());
        auditLogger.setBuilder((AuditEventBuilder)auditEventBuilder);
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.getEmf()).knowledgeBase(kbase).classLoader(kieContainer.getClassLoader());
        if (this.beanManager != null) {
            builder.registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AbstractAuditLogger)auditLogger, (KieContainer)kieContainer, (String)kmoduleUnit.getKsessionName()));
        }
        this.commonDeploy(unit, deployedUnit, builder.get());
    }
}

