/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskEvent;

public class NonManagedTaskEventListener
implements TaskLifeCycleEventListener {
    private KieSession ksession;
    private TaskService taskService;

    public NonManagedTaskEventListener(KieSession ksession, TaskService taskService) {
        this.ksession = ksession;
        this.taskService = taskService;
    }

    public void processTaskState(Task task) {
        long workItemId = task.getTaskData().getWorkItemId();
        if (task.getTaskData().getStatus() == Status.Completed) {
            String userId = task.getTaskData().getActualOwner().getId();
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("ActorId", userId);
            long contentId = task.getTaskData().getOutputContentId();
            if (contentId != -1L) {
                Content content = this.taskService.getContentById(contentId);
                Object result = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)this.ksession.getEnvironment(), (ClassLoader)this.ksession.getClass().getClassLoader());
                results.put("Result", result);
                if (result instanceof Map) {
                    Map map = (Map)result;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof String)) continue;
                        results.put((String)entry.getKey(), entry.getValue());
                    }
                }
                this.ksession.getWorkItemManager().completeWorkItem(task.getTaskData().getWorkItemId(), results);
            } else {
                this.ksession.getWorkItemManager().completeWorkItem(workItemId, results);
            }
        } else {
            this.ksession.getWorkItemManager().abortWorkItem(workItemId);
        }
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        Task task = event.getTask();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        this.processTaskState(task);
    }

    public void afterTaskStartedEvent(TaskEvent event) {
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        Task task = event.getTask();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        this.processTaskState(task);
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        Task task = event.getTask();
        long processInstanceId = task.getTaskData().getProcessInstanceId();
        if (processInstanceId <= 0L) {
            return;
        }
        this.processTaskState(task);
    }

    public void afterTaskAddedEvent(TaskEvent event) {
    }

    public void afterTaskExitedEvent(TaskEvent event) {
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
    }

    public void afterTaskResumedEvent(TaskEvent event) {
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
    }
}

