/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.Context;

@XmlRootElement(name="get-task-by-various-fields-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetTasksByVariousFieldsCommand
extends UserGroupCallbackTaskCommand<List<TaskSummary>> {
    private static final long serialVersionUID = -4894264083829084547L;
    @XmlElement
    private List<Long> workItemIds;
    @XmlElement
    private List<Long> taskIds;
    @XmlElement(name="process-instance-id")
    private List<Long> procInstIds;
    @XmlElement(name="business-admin")
    private List<String> busAdmins;
    @XmlElement(name="potential-owner")
    private List<String> potOwners;
    @XmlElement(name="task-owner")
    private List<String> taskOwners;
    @XmlElement(name="status")
    private List<Status> statuses;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean union;
    @XmlElement
    private List<String> language;

    public GetTasksByVariousFieldsCommand() {
    }

    public GetTasksByVariousFieldsCommand(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> statuses, boolean union) {
        this(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, null, union);
    }

    public GetTasksByVariousFieldsCommand(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> statuses, List<String> language, boolean union) {
        this.workItemIds = workItemIds;
        this.taskIds = taskIds;
        this.procInstIds = procInstIds;
        this.busAdmins = busAdmins;
        this.potOwners = potOwners;
        this.taskOwners = taskOwners;
        this.statuses = statuses;
        this.union = union;
        this.language = language;
    }

    public GetTasksByVariousFieldsCommand(Map<String, List<?>> params, boolean union) {
        this.union = union;
        if (params == null) {
            return;
        }
        this.workItemIds = params.get("Work item id list");
        this.taskIds = params.get("task id list");
        this.procInstIds = params.get("process instance id list");
        this.busAdmins = params.get("business admin id list");
        this.potOwners = params.get("potential owner id list");
        this.taskOwners = params.get("task owner id list");
        this.statuses = params.get("status list");
        this.language = params.get("language");
    }

    @Override
    public List<TaskSummary> execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        this.potOwners = this.populateOrganizationalEntityWithGroupInfo(this.potOwners, context);
        this.busAdmins = this.populateOrganizationalEntityWithGroupInfo(this.busAdmins, context);
        return context.getTaskQueryService().getTasksByVariousFields(this.workItemIds, this.taskIds, this.procInstIds, this.busAdmins, this.potOwners, this.taskOwners, this.statuses, this.language, this.union.booleanValue());
    }

    public List<Long> getWorkItemIds() {
        return this.workItemIds;
    }

    public void setWorkItemIds(List<Long> workItemIds) {
        this.workItemIds = workItemIds;
    }

    public List<Long> getTaskIds() {
        return this.taskIds;
    }

    public void setTaskIds(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    public List<Long> getProcInstIds() {
        return this.procInstIds;
    }

    public void setProcInstIds(List<Long> procInstIds) {
        this.procInstIds = procInstIds;
    }

    public List<String> getBusAdmins() {
        return this.busAdmins;
    }

    public void setBusAdmins(List<String> busAdmins) {
        this.busAdmins = busAdmins;
    }

    public List<String> getPotOwners() {
        return this.potOwners;
    }

    public void setPotOwners(List<String> potOwners) {
        this.potOwners = potOwners;
    }

    public List<String> getTaskOwners() {
        return this.taskOwners;
    }

    public void setTaskOwners(List<String> taskOwners) {
        this.taskOwners = taskOwners;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<Status> statuses) {
        this.statuses = statuses;
    }

    public List<String> getLanguage() {
        return this.language;
    }

    public void setLanguage(List<String> language) {
        this.language = language;
    }

    public Boolean getUnion() {
        return this.union;
    }

    public void setUnion(Boolean union) {
        this.union = union;
    }

    protected List<String> populateOrganizationalEntityWithGroupInfo(List<String> entities, TaskContext context) {
        if (entities != null && entities.size() > 0) {
            HashSet<String> groupIds = new HashSet<String>();
            for (String userId : entities) {
                List<String> tmp = this.doUserGroupCallbackOperation(userId, null, context);
                if (tmp == null) continue;
                groupIds.addAll(tmp);
            }
            groupIds.addAll(entities);
            return new ArrayList<String>(groupIds);
        }
        return entities;
    }
}

