/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.wagon;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import java.io.IOException;
import org.sonatype.maven.wagon.GetExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetExchangeHandler
implements AsyncHandler<String> {
    private GetExchange exchange;

    public GetExchangeHandler(GetExchange exchange) {
        this.exchange = exchange;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.exchange.setStatusCode(responseStatus.getStatusCode());
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        FluentCaseInsensitiveStringsMap h = headers.getHeaders();
        this.exchange.setLastModified(h.getFirstValue("Last-Modified"));
        this.exchange.setContentLength(h.getFirstValue("Content-Length"));
        this.exchange.start();
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        bodyPart.writeTo(this.exchange.getOutputStream());
        return AsyncHandler.STATE.CONTINUE;
    }

    public String onCompleted() throws Exception {
        if (this.exchange != null) {
            this.exchange.getOutputStream().close();
            this.exchange.start();
        }
        return "";
    }

    public void onThrowable(Throwable t) {
        if (this.exchange != null) {
            this.exchange.fail(t);
            this.exchange.start();
            try {
                this.exchange.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

