/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.cdi.producer;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskServiceProducer {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskServiceProducer.class);
    @Inject
    private Instance<UserGroupCallback> userGroupCallback;
    @Inject
    private Instance<UserInfo> userInfo;
    @Inject
    @Any
    private Instance<TaskLifeCycleEventListener> taskListeners;
    private InternalTaskService taskService;

    @Produces
    public CommandBasedTaskService produceTaskService(EntityManagerFactory emf) {
        if (this.taskService == null) {
            HumanTaskConfigurator configurator = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(emf).userGroupCallback(this.safeGet(this.userGroupCallback)).userInfo(this.safeGet(this.userInfo));
            try {
                for (TaskLifeCycleEventListener listener : this.taskListeners) {
                    configurator.listener(listener);
                    logger.debug("Registering listener {}", (Object)listener);
                }
            }
            catch (Exception e) {
                logger.warn("Cannot add listeners to task service due to {}", (Object)e.getMessage());
            }
            this.taskService = (CommandBasedTaskService)configurator.getTaskService();
        }
        return (CommandBasedTaskService)this.taskService;
    }

    protected <T> T safeGet(Instance<T> instance) {
        try {
            Object object = instance.get();
            logger.debug("About to set object {} on task service", object);
            return (T)object;
        }
        catch (Throwable e) {
            logger.warn("Cannot get value of of instance {} due to {}", instance, (Object)e.getMessage());
            return null;
        }
    }
}

