/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.java;

import java.util.Arrays;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.dialect.java.JavaDialect;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.rule.Package;
import org.drools.core.rule.builder.dialect.asm.ClassLevel;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDialectConfiguration
implements DialectConfiguration {
    protected static transient Logger logger = LoggerFactory.getLogger(JavaDialectConfiguration.class);
    public static final String JAVA_COMPILER_PROPERTY = "drools.dialect.java.compiler";
    public static final int ECLIPSE = 0;
    public static final int JANINO = 1;
    public static final int NATIVE = 2;
    public static final String[] LANGUAGE_LEVELS = new String[]{"1.5", "1.6", "1.7"};
    private String languageLevel;
    private PackageBuilderConfiguration conf;
    private int compiler;

    @Override
    public void init(PackageBuilderConfiguration conf) {
        this.conf = conf;
        this.setCompiler(this.getDefaultCompiler());
        this.setJavaLanguageLevel(this.getDefaultLanguageLevel());
    }

    @Override
    public PackageBuilderConfiguration getPackageBuilderConfiguration() {
        return this.conf;
    }

    @Override
    public Dialect newDialect(PackageBuilder packageBuilder, PackageRegistry pkgRegistry, Package pkg) {
        return new JavaDialect(packageBuilder, pkgRegistry, pkg);
    }

    public String getJavaLanguageLevel() {
        return this.languageLevel;
    }

    public void setJavaLanguageLevel(String languageLevel) {
        if (Arrays.binarySearch(LANGUAGE_LEVELS, languageLevel) < 0) {
            throw new RuntimeDroolsException("value '" + languageLevel + "' is not a valid language level");
        }
        this.languageLevel = languageLevel;
    }

    public void setCompiler(int compiler) {
        if (compiler == 0) {
            try {
                Class.forName("org.eclipse.jdt.internal.compiler.Compiler", true, this.conf.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The Eclipse JDT Core jar is not in the classpath");
            }
        }
        if (compiler == 1) {
            try {
                Class.forName("org.codehaus.janino.Parser", true, this.conf.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The Janino jar is not in the classpath");
            }
        }
        switch (compiler) {
            case 0: {
                this.compiler = 0;
                break;
            }
            case 1: {
                this.compiler = 1;
                break;
            }
            case 2: {
                this.compiler = 2;
                break;
            }
            default: {
                throw new RuntimeDroolsException("value '" + compiler + "' is not a valid compiler");
            }
        }
    }

    public int getCompiler() {
        return this.compiler;
    }

    private int getDefaultCompiler() {
        try {
            String prop = this.conf.getChainedProperties().getProperty(JAVA_COMPILER_PROPERTY, "ECLIPSE");
            if (prop.equals("NATIVE")) {
                return 2;
            }
            if (prop.equals("ECLIPSE")) {
                return 0;
            }
            if (prop.equals("JANINO")) {
                return 1;
            }
            logger.error("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + prop);
            return 0;
        }
        catch (SecurityException e) {
            logger.error("Drools config: unable to read the drools.compiler property. Using default.", (Throwable)e);
            return 0;
        }
    }

    private String getDefaultLanguageLevel() {
        switch (ClassLevel.findJavaVersion((ChainedProperties)this.conf.getChainedProperties())) {
            case 49: {
                return "1.5";
            }
            case 50: {
                return "1.6";
            }
            case 51: {
                return "1.7";
            }
        }
        return "1.6";
    }
}

