/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.lifecycle.listeners;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMTaskEventListener
implements TaskLifeCycleEventListener {
    private static final Logger logger = LoggerFactory.getLogger(BAMTaskEventListener.class);

    public void afterTaskStartedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, new BAMTaskWorker(){

            @Override
            public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl bamTask, Task task) {
                bamTask.setStartDate(new Date());
                return bamTask;
            }

            @Override
            public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl bamTask, Task task) {
                bamTask.setStartDate(new Date());
                return bamTask;
            }
        });
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, new BAMTaskWorker(){

            @Override
            public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl bamTask, Task task) {
                return bamTask;
            }

            @Override
            public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl bamTask, Task task) {
                Date completedDate = new Date();
                bamTask.setEndDate(completedDate);
                bamTask.setDuration(completedDate.getTime() - bamTask.getStartDate().getTime());
                return bamTask;
            }
        });
    }

    public void afterTaskAddedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, Status.Exited);
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, Status.Exited);
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, Status.Error);
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        this.createOrUpdateTask(event, Status.Exited);
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskForwaredEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskNomiatedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskResumedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
        this.createOrUpdateTask(event);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(TaskEvent event, BAMTaskWorker worker) {
        return this.createOrUpdateTask(event, null, worker);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(TaskEvent event) {
        return this.createOrUpdateTask(event, null, null);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(TaskEvent event, Status newStatus) {
        return this.createOrUpdateTask(event, newStatus, null);
    }

    protected BAMTaskSummaryImpl createOrUpdateTask(TaskEvent event, Status newStatus, BAMTaskWorker worker) {
        BAMTaskSummaryImpl result = null;
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = ((TaskContext)event.getTaskContext()).getPersistenceContext();
        if (ti == null) {
            logger.error("The task instance does not exist.");
            return result;
        }
        Status status = newStatus != null ? newStatus : ti.getTaskData().getStatus();
        List taskSummaries = (List)persistenceContext.queryStringWithParametersInTransaction("select bts from BAMTaskSummaryImpl bts where bts.taskId=:taskId", (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(List.class));
        if (taskSummaries.isEmpty()) {
            String actualOwner = "";
            if (ti.getTaskData().getActualOwner() != null) {
                actualOwner = ti.getTaskData().getActualOwner().getId();
            }
            result = new BAMTaskSummaryImpl(ti.getId(), ((I18NText)ti.getNames().get(0)).getText(), status.toString(), new Date(), actualOwner, ti.getTaskData().getProcessInstanceId());
            if (worker != null) {
                worker.createTask(result, ti);
            }
            persistenceContext.persist((Object)result);
        } else if (taskSummaries.size() == 1) {
            result = (BAMTaskSummaryImpl)taskSummaries.get(0);
            result.setStatus(status.toString());
            if (ti.getTaskData().getActualOwner() != null) {
                result.setUserId(ti.getTaskData().getActualOwner().getId());
            }
            if (worker != null) {
                worker.updateTask(result, ti);
            }
            persistenceContext.merge((Object)result);
        } else {
            logger.warn("Something went wrong with the Task BAM Listener");
            throw new IllegalStateException("We cannot have more than one BAM Task Summary for the task id = " + ti.getId());
        }
        return result;
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    protected static interface BAMTaskWorker {
        public BAMTaskSummaryImpl createTask(BAMTaskSummaryImpl var1, Task var2);

        public BAMTaskSummaryImpl updateTask(BAMTaskSummaryImpl var1, Task var2);
    }
}

