/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.NetworkNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.TupleEntry;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Rule;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.AtomicBitwiseLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMemory
extends AbstractBaseLinkedListNode<Memory>
implements Memory {
    protected static transient Logger log = LoggerFactory.getLogger(PathMemory.class);
    private AtomicBitwiseLong linkedSegmentMask;
    private long allLinkedMaskTest;
    private NetworkNode networkNode;
    private volatile RuleAgendaItem agendaItem;
    private SegmentMemory[] segmentMemories;
    private SegmentMemory segmentMemory;
    protected Queue queue;

    public PathMemory(NetworkNode networkNode) {
        this.networkNode = networkNode;
        this.linkedSegmentMask = new AtomicBitwiseLong();
    }

    public void initQueue() {
        this.queue = new ConcurrentLinkedQueue();
    }

    public Queue<TupleEntry> getTupleQueue() {
        return this.queue;
    }

    public NetworkNode getNetworkNode() {
        return this.networkNode;
    }

    public Rule getRule() {
        return ((TerminalNode)this.getNetworkNode()).getRule();
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.agendaItem;
    }

    public void setlinkedSegmentMask(long mask) {
        this.linkedSegmentMask.set(mask);
    }

    public long getLinkedSegmentMask() {
        return this.linkedSegmentMask.get();
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public void linkNodeWithoutRuleNotify(long mask) {
        this.linkedSegmentMask.getAndBitwiseOr(mask);
    }

    public void linkSegment(long mask, InternalWorkingMemory wm) {
        this.linkedSegmentMask.getAndBitwiseOr(mask);
        if (log.isTraceEnabled()) {
            if (NodeTypeEnums.isTerminalNode(this.getNetworkNode())) {
                TerminalNode rtn = (TerminalNode)this.getNetworkNode();
                log.trace("  LinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, rtn.getRule().getName()});
            } else {
                log.trace("  LinkSegment smask={} rmask={} name={}", (Object)mask, (Object)"RiaNode");
            }
        }
        if (this.isRuleLinked()) {
            this.doLinkRule(wm);
        }
    }

    public synchronized void doLinkRule(InternalWorkingMemory wm) {
        TerminalNode rtn = (TerminalNode)this.getNetworkNode();
        if (log.isTraceEnabled()) {
            log.trace("    LinkRule name={}", (Object)rtn.getRule().getName());
        }
        if (this.agendaItem == null) {
            int salience = rtn.getRule().getSalience() instanceof MVELSalienceExpression ? 0 : rtn.getRule().getSalience().getValue(null, rtn.getRule(), wm);
            this.agendaItem = ((InternalAgenda)wm.getAgenda()).createRuleAgendaItem(salience, this, rtn);
        }
        this.queueRuleAgendaItem(wm);
    }

    public synchronized void doUnlinkRule(InternalWorkingMemory wm) {
        TerminalNode rtn = (TerminalNode)this.getNetworkNode();
        if (log.isTraceEnabled()) {
            log.trace("    UnlinkRule name={}", (Object)rtn.getRule().getName());
        }
        if (this.agendaItem == null) {
            int salience = rtn.getRule().getSalience() instanceof MVELSalienceExpression ? 0 : rtn.getRule().getSalience().getValue(null, rtn.getRule(), wm);
            this.agendaItem = ((InternalAgenda)wm.getAgenda()).createRuleAgendaItem(salience, this, rtn);
        }
        this.queueRuleAgendaItem(wm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRuleAgendaItem(InternalWorkingMemory wm) {
        InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
        RuleAgendaItem ruleAgendaItem = this.agendaItem;
        synchronized (ruleAgendaItem) {
            this.agendaItem.getRuleExecutor().setDirty(true);
            ActivationsFilter activationFilter = agenda.getActivationsFilter();
            if (activationFilter != null && !activationFilter.accept(this.agendaItem, wm, this.agendaItem.getTerminalNode())) {
                return;
            }
            if (!this.agendaItem.isQueued() && !this.agendaItem.isBlocked()) {
                if (log.isTraceEnabled()) {
                    log.trace("Queue RuleAgendaItem {}", (Object)this.agendaItem);
                }
                InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
                ag.add(this.agendaItem);
            }
        }
        if (this.agendaItem.getRule().isEager()) {
            ((InternalAgenda)wm.getAgenda()).addEagerRuleAgendaItem(this.agendaItem);
        }
        agenda.notifyHalt();
    }

    public void unlinkedSegment(long mask, InternalWorkingMemory wm) {
        boolean linkedRule = this.isRuleLinked();
        this.linkedSegmentMask.getAndBitwiseXor(mask);
        if (log.isTraceEnabled()) {
            log.trace("  UnlinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, this});
        }
        if (linkedRule && !this.isRuleLinked()) {
            this.doUnlinkRule(wm);
        }
    }

    public boolean isRuleLinked() {
        return (this.linkedSegmentMask.get() & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    @Override
    public short getNodeType() {
        return 101;
    }

    public SegmentMemory[] getSegmentMemories() {
        return this.segmentMemories;
    }

    public void setSegmentMemories(SegmentMemory[] segmentMemories) {
        this.segmentMemories = segmentMemories;
    }

    @Override
    public SegmentMemory getSegmentMemory() {
        return this.segmentMemory;
    }

    @Override
    public void setSegmentMemory(SegmentMemory sm) {
        this.segmentMemory = sm;
    }

    public String toString() {
        return "[RuleMem " + this.getRule().getName() + "]";
    }
}

