/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.timer;

import org.drools.core.command.CommandService;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.jpa.JDKCallableJobCommand;
import org.drools.persistence.jpa.JpaTimerJobInstance;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.persistence.timer.GlobalJPATimerJobFactoryManager;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.kie.api.command.Command;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJpaTimerJobInstance
extends JpaTimerJobInstance {
    private static final Logger logger = LoggerFactory.getLogger(GlobalJpaTimerJobInstance.class);
    private static final long serialVersionUID = -5383556604449217342L;
    private String timerServiceId;

    public GlobalJpaTimerJobInstance(Job job, JobContext ctx, Trigger trigger, JobHandle handle, InternalSchedulerService scheduler) {
        super(job, ctx, trigger, handle, scheduler);
        this.timerServiceId = ((GlobalTimerService)scheduler).getTimerServiceId();
    }

    public Void call() throws Exception {
        CommandService commandService = null;
        try {
            JDKCallableJobCommand command = new JDKCallableJobCommand((JpaTimerJobInstance)this);
            if (this.scheduler == null) {
                this.scheduler = (InternalSchedulerService)TimerServiceRegistry.getInstance().get(this.timerServiceId);
            }
            commandService = ((GlobalTimerService)this.scheduler).getCommandService(this.getJobContext());
            commandService.execute((Command)command);
            GlobalJPATimerJobFactoryManager timerService = (GlobalJPATimerJobFactoryManager)((GlobalTimerService)this.scheduler).getTimerJobFactoryManager();
            timerService.removeTimerJobInstance(((DefaultJobHandle)this.getJobHandle()).getTimerJobInstance());
            Void void_ = null;
            return void_;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (commandService != null && commandService instanceof GlobalTimerService.DisposableCommandService && this.allowedToDispose(((GlobalTimerService.DisposableCommandService)commandService).getEnvironment())) {
                logger.debug("Allowed to dispose command service from global timer job instance");
                ((GlobalTimerService.DisposableCommandService)commandService).dispose();
            }
        }
    }

    protected boolean allowedToDispose(Environment environment) {
        if (this.hasEnvironmentEntry(environment, "IS_JTA_TRANSACTION", false)) {
            return true;
        }
        Object transactionManager = null;
        Object txm = environment.get("org.kie.transaction.TransactionManager");
        transactionManager = txm != null && txm instanceof TransactionManager ? (TransactionManager)txm : new JtaTransactionManager(null, null, null);
        int status = transactionManager.getStatus();
        return status == 3 || status == 1 || status == 0;
    }

    protected boolean hasEnvironmentEntry(Environment environment, String name, Object value) {
        Object envEntry = environment.get(name);
        if (value == null) {
            return envEntry == null;
        }
        return value.equals(envEntry);
    }
}

