/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.PerDocProducer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;

public abstract class PerDocProducerBase
extends PerDocProducer {
    protected abstract void closeInternal(Collection<? extends Closeable> var1) throws IOException;

    protected abstract Map<String, DocValues> docValues();

    protected PerDocProducerBase() {
    }

    @Override
    public void close() throws IOException {
        this.closeInternal(this.docValues().values());
    }

    @Override
    public DocValues docValues(String field) throws IOException {
        return this.docValues().get(field);
    }

    public Comparator<BytesRef> getComparator() throws IOException {
        return BytesRef.getUTF8SortedAsUnicodeComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TreeMap<String, DocValues> load(FieldInfos fieldInfos, String segment, int docCount, Directory dir, IOContext context) throws IOException {
        TreeMap<String, DocValues> values = new TreeMap<String, DocValues>();
        boolean success = false;
        try {
            for (FieldInfo fieldInfo : fieldInfos) {
                if (!this.canLoad(fieldInfo)) continue;
                String field = fieldInfo.name;
                String id = PerDocProducerBase.docValuesId(segment, fieldInfo.number);
                values.put(field, this.loadDocValues(docCount, dir, id, this.getDocValuesType(fieldInfo), context));
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.closeInternal(values.values());
                }
                catch (Throwable t) {}
            }
        }
        return values;
    }

    protected boolean canLoad(FieldInfo info) {
        return info.hasDocValues();
    }

    protected DocValues.Type getDocValuesType(FieldInfo info) {
        return info.getDocValuesType();
    }

    protected boolean anyDocValuesFields(FieldInfos infos) {
        return infos.hasDocValues();
    }

    public static String docValuesId(String segmentsName, int fieldId) {
        return segmentsName + "_" + fieldId;
    }

    protected abstract DocValues loadDocValues(int var1, Directory var2, String var3, DocValues.Type var4, IOContext var5) throws IOException;
}

