/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.ClassFieldAccessor;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassFieldWriter;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.extractors.MVELDateClassFieldReader;
import org.drools.core.base.extractors.MVELNumberClassFieldReader;
import org.drools.core.base.extractors.MVELObjectClassFieldReader;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Acceptor;
import org.drools.core.spi.AcceptsClassObjectType;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.AcceptsWriteAccessor;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.asm.ClassFieldInspector;
import org.kie.api.definition.type.FactField;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class ClassFieldAccessorStore
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<AccessorKey, BaseLookupEntry> lookup = new HashMap<AccessorKey, BaseLookupEntry>();
    private ClassFieldAccessorCache cache;
    private boolean eagerWire = true;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lookup);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lookup = (Map)in.readObject();
    }

    public void setEagerWire(boolean eagerWire) {
        this.eagerWire = eagerWire;
    }

    public void setClassFieldAccessorCache(ClassFieldAccessorCache cache) {
        this.cache = cache;
    }

    public ClassFieldWriter getWriter(Class cls, String fieldName, ClassLoader classLoader) {
        return this.getWriter(cls.getName(), fieldName, null);
    }

    public ClassFieldReader getReader(Class cls, String fieldName, ClassLoader classLoader) {
        return this.getReader(cls.getName(), fieldName, null, AccessorKey.AccessorType.FieldAccessor);
    }

    public ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target) {
        return this.getReader(className, fieldName, target, AccessorKey.AccessorType.FieldAccessor);
    }

    public synchronized ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target, AccessorKey.AccessorType accessorType) {
        AccessorKey key = new AccessorKey(className, fieldName, accessorType);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        boolean exists = true;
        if (entry == null) {
            exists = false;
            entry = new FieldLookupEntry(new ClassFieldReader(className, fieldName));
        }
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
            ClassFieldReader reader = (ClassFieldReader)entry.getClassFieldReader();
            if (!reader.hasReadAccessor()) {
                return null;
            }
        }
        if (target != null) {
            target.setReadAccessor(entry.getClassFieldReader());
            entry.addAccessorTarget(target);
        }
        if (!exists) {
            this.lookup.put(key, entry);
        }
        return (ClassFieldReader)entry.getClassFieldReader();
    }

    public InternalReadAccessor getMVELReader(String pkgName, String className, String expr, boolean typesafe, Class returnType) {
        AccessorKey key = new AccessorKey(pkgName + className, expr, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        if (entry == null) {
            InternalReadAccessor reader = ClassFieldAccessorStore.getReadAcessor(className, expr, typesafe, returnType);
            entry = new FieldLookupEntry(reader);
            this.lookup.put(key, entry);
        }
        return entry.getClassFieldReader();
    }

    public static InternalReadAccessor getReadAcessor(String className, String expr, boolean typesafe, Class returnType) {
        if (Number.class.isAssignableFrom(returnType) || returnType == Byte.TYPE || returnType == Short.TYPE || returnType == Integer.TYPE || returnType == Long.TYPE || returnType == Float.TYPE || returnType == Double.TYPE) {
            return new MVELNumberClassFieldReader(className, expr, typesafe);
        }
        if (Date.class.isAssignableFrom(returnType)) {
            return new MVELDateClassFieldReader(className, expr, typesafe);
        }
        return new MVELObjectClassFieldReader(className, expr, typesafe);
    }

    public synchronized ClassFieldWriter getWriter(String className, String fieldName, AcceptsWriteAccessor target) {
        AccessorKey key = new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        boolean exists = true;
        if (entry == null) {
            exists = false;
            entry = new FieldLookupEntry(new ClassFieldWriter(className, fieldName));
        }
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
        }
        if (target != null) {
            target.setWriteAccessor(entry.getClassFieldWriter());
            entry.addAccessorTarget(target);
        }
        if (!exists) {
            this.lookup.put(key, entry);
        }
        return entry.getClassFieldWriter();
    }

    public ClassFieldAccessor getAccessor(Class cls, String fieldName, ClassLoader classLoader) {
        return this.getAccessor(cls.getName(), fieldName);
    }

    public ClassFieldAccessor getAccessor(String className, String fieldName) {
        AccessorKey key = new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        if (entry == null) {
            entry = new FieldLookupEntry(new ClassFieldReader(className, fieldName), new ClassFieldWriter(className, fieldName));
            this.lookup.put(key, entry);
        }
        ClassFieldAccessor accessor = new ClassFieldAccessor((ClassFieldReader)entry.getClassFieldReader(), entry.getClassFieldWriter());
        entry.addAccessorTarget(accessor);
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
            this.wire(entry.getClassFieldWriter());
        }
        return accessor;
    }

    public ClassObjectType getClassObjectType(ClassObjectType objectType, AcceptsClassObjectType target) {
        return this.getClassObjectType(objectType, objectType.isEvent(), target);
    }

    public ClassObjectType getClassObjectType(ClassObjectType objectType, boolean isEvent, AcceptsClassObjectType target) {
        AccessorKey key = new AccessorKey(objectType.getClassName(), isEvent ? "$$DROOLS__isEvent__" : null, AccessorKey.AccessorType.ClassObjectType);
        ClassObjectTypeLookupEntry entry = (ClassObjectTypeLookupEntry)this.lookup.get(key);
        if (entry == null) {
            entry = new ClassObjectTypeLookupEntry(this.cache.getClassObjectType(objectType));
            this.lookup.put(key, entry);
        }
        if (target != null) {
            entry.addAccessorTarget(target);
            target.setClassObjectType(entry.getClassObjectType());
        }
        return entry.getClassObjectType();
    }

    public void removeType(TypeDeclaration type) {
        this.lookup.remove(new AccessorKey(type.getTypeClassName(), null, AccessorKey.AccessorType.ClassObjectType));
        for (FactField field : type.getTypeClassDef().getFields()) {
            this.lookup.remove(new AccessorKey(type.getTypeClassName(), field.getName(), AccessorKey.AccessorType.FieldAccessor));
        }
    }

    public void merge(ClassFieldAccessorStore other) {
        for (Map.Entry<AccessorKey, BaseLookupEntry> entry : other.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    BaseLookupEntry lookupEntry = (FieldLookupEntry)this.lookup.get(entry.getKey());
                    if (lookupEntry == null) {
                        lookupEntry = (FieldLookupEntry)entry.getValue();
                        this.lookup.put(entry.getKey(), lookupEntry);
                        for (Acceptor target : lookupEntry.getAccessorTargets()) {
                            if (!(target instanceof ClassWireable)) continue;
                            this.wire((ClassWireable)((Object)target));
                        }
                    } else {
                        for (Acceptor target : entry.getValue().getAccessorTargets()) {
                            if (target instanceof AcceptsReadAccessor) {
                                ((AcceptsReadAccessor)target).setReadAccessor(((FieldLookupEntry)lookupEntry).getClassFieldReader());
                            } else if (target instanceof AcceptsWriteAccessor) {
                                ((AcceptsWriteAccessor)target).setWriteAccessor(((FieldLookupEntry)lookupEntry).getClassFieldWriter());
                            }
                            lookupEntry.addAccessorTarget(target);
                        }
                    }
                    if (((FieldLookupEntry)lookupEntry).getClassFieldReader() != null) {
                        this.wire(((FieldLookupEntry)entry.getValue()).getClassFieldReader());
                    }
                    if (((FieldLookupEntry)lookupEntry).getClassFieldWriter() == null) break;
                    this.wire(((FieldLookupEntry)entry.getValue()).getClassFieldWriter());
                    break;
                }
                case ClassObjectType: {
                    BaseLookupEntry lookupEntry = (ClassObjectTypeLookupEntry)this.lookup.get(entry.getKey());
                    if (lookupEntry == null) {
                        lookupEntry = new ClassObjectTypeLookupEntry(this.cache.getClassObjectType(((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType()));
                        this.lookup.put(entry.getKey(), lookupEntry);
                    }
                    for (Acceptor target : entry.getValue().getAccessorTargets()) {
                        ((AcceptsClassObjectType)target).setClassObjectType(((ClassObjectTypeLookupEntry)lookupEntry).getClassObjectType());
                        lookupEntry.addAccessorTarget(target);
                    }
                    break;
                }
            }
        }
    }

    public void wire() {
        for (Map.Entry<AccessorKey, BaseLookupEntry> entry : this.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    ClassFieldWriter writer;
                    InternalReadAccessor reader = ((FieldLookupEntry)entry.getValue()).getClassFieldReader();
                    if (reader != null) {
                        this.wire(reader);
                    }
                    if ((writer = ((FieldLookupEntry)entry.getValue()).getClassFieldWriter()) == null) break;
                    this.wire(writer);
                    break;
                }
                case ClassObjectType: {
                    ClassObjectType classObjectType = ((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType();
                    this.wire(classObjectType);
                    break;
                }
            }
        }
    }

    public void wire(InternalReadAccessor reader) {
        if (reader instanceof ClassFieldReader) {
            ((ClassFieldReader)reader).setReadAccessor(this.cache.getReadAcessor((ClassFieldReader)reader));
        }
    }

    public void wire(ClassFieldWriter writer) {
        writer.setWriteAccessor(this.cache.getWriteAcessor(writer));
    }

    public void wire(ClassWireable wireable) {
        try {
            if (wireable.getClassType() == null || !wireable.getClassType().isPrimitive()) {
                Class<?> cls = this.cache.getClassLoader().loadClass(wireable.getClassName());
                wireable.wire(cls);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load ClassObjectType class '" + wireable.getClassName() + "'");
        }
    }

    public Collection<KnowledgeBuilderResult> getWiringResults(Class klass, String fieldName) {
        if (this.cache == null) {
            return Collections.EMPTY_LIST;
        }
        Map<Class<?>, ClassFieldInspector> inspectors = this.cache.getCacheEntry(klass).getInspectors();
        return inspectors.containsKey(klass) ? inspectors.get(klass).getInspectionResults(fieldName) : Collections.EMPTY_LIST;
    }

    public static class FieldLookupEntry
    extends BaseLookupEntry {
        private InternalReadAccessor reader;
        private ClassFieldWriter writer;

        public FieldLookupEntry() {
        }

        public FieldLookupEntry(InternalReadAccessor reader) {
            this.reader = reader;
        }

        public FieldLookupEntry(ClassFieldWriter writer) {
            this.writer = writer;
        }

        public FieldLookupEntry(ClassFieldReader reader, ClassFieldWriter writer) {
            this.writer = writer;
            this.reader = reader;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.reader);
            out.writeObject(this.writer);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.reader = (InternalReadAccessor)in.readObject();
            this.writer = (ClassFieldWriter)in.readObject();
        }

        public InternalReadAccessor getClassFieldReader() {
            return this.reader;
        }

        public ClassFieldWriter getClassFieldWriter() {
            return this.writer;
        }

        @Override
        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.FieldAccessor;
        }
    }

    public static class ClassObjectTypeLookupEntry
    extends BaseLookupEntry {
        ClassObjectType classObjectType;

        public ClassObjectTypeLookupEntry() {
        }

        public ClassObjectTypeLookupEntry(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.classObjectType);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.classObjectType = (ClassObjectType)in.readObject();
        }

        public ClassObjectType getClassObjectType() {
            return this.classObjectType;
        }

        public void setClassObjectType(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        @Override
        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.ClassObjectType;
        }
    }

    public static abstract class BaseLookupEntry
    implements Externalizable {
        private Map<Acceptor, Object> accessorTargets = Collections.emptyMap();

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.accessorTargets);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.accessorTargets = (Map)in.readObject();
        }

        public Set<Acceptor> getAccessorTargets() {
            return this.accessorTargets.keySet();
        }

        public void addAccessorTarget(Acceptor target) {
            if (this.accessorTargets == Collections.EMPTY_MAP) {
                this.accessorTargets = new IdentityHashMap<Acceptor, Object>();
            }
            this.accessorTargets.put(target, null);
        }

        public void addAccessorTargets(Set<Acceptor> targets) {
            if (this.accessorTargets == Collections.EMPTY_MAP) {
                this.accessorTargets = new IdentityHashMap<Acceptor, Object>();
            }
            for (Acceptor target : targets) {
                this.accessorTargets.put(target, null);
            }
        }

        public void removeTarget(Acceptor target) {
            this.accessorTargets.remove(target);
        }

        public abstract AccessorKey.AccessorType getAccessorType();
    }
}

