/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.model.xml;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.jbpm.services.task.impl.model.xml.AbstractJaxbTaskObject;
import org.jbpm.services.task.impl.model.xml.adapter.StatusXmlAdapter;
import org.jbpm.services.task.impl.model.xml.adapter.SubTasksStrategyXmlAdapter;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.model.SubTasksStrategy;

@XmlRootElement(name="task-summary")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={Status.class, SubTasksStrategy.class})
public class JaxbTaskSummary
implements TaskSummary {
    @XmlElement
    @XmlSchemaType(name="long")
    private long id;
    @XmlElement
    @XmlSchemaType(name="string")
    private String name;
    @XmlElement
    @XmlSchemaType(name="string")
    private String subject;
    @XmlElement
    @XmlSchemaType(name="string")
    private String description;
    @XmlElement
    @XmlJavaTypeAdapter(value=StatusXmlAdapter.class, type=Status.class)
    private Status status;
    @XmlElement
    @XmlSchemaType(name="int")
    private int priority;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private boolean skipable;
    @XmlElement(name="actual-owner")
    private String actualOwnerId;
    @XmlElement(name="created-by")
    private String createdById;
    @XmlElement(name="created-on")
    @XmlSchemaType(name="dateTime")
    private Date createdOn;
    @XmlElement(name="activation-time")
    @XmlSchemaType(name="dateTime")
    private Date activationTime;
    @XmlElement(name="expiration-time")
    @XmlSchemaType(name="dateTime")
    private Date expirationTime;
    @XmlElement(name="process-instance-id")
    @XmlSchemaType(name="long")
    private long processInstanceId;
    @XmlElement(name="process-id")
    @XmlSchemaType(name="string")
    private String processId;
    @XmlElement(name="process-session-id")
    @XmlSchemaType(name="int")
    private int processSessionId;
    @XmlElement(name="deployment-id")
    @XmlSchemaType(name="string")
    private String deploymentId;
    @XmlElement(name="quick-task-summary")
    @XmlSchemaType(name="boolean")
    private boolean quickTaskSummary;
    @XmlElement(name="sub-task-strategy")
    @XmlJavaTypeAdapter(value=SubTasksStrategyXmlAdapter.class, type=SubTasksStrategy.class)
    private SubTasksStrategy subTaskStrategy;
    @XmlElement(name="parent-id")
    @XmlSchemaType(name="long")
    private long parentId;
    @XmlElement(name="potential-owner")
    private List<String> potentialOwners;

    public JaxbTaskSummary(TaskSummary taskSum) {
        User created;
        this.id = taskSum.getId();
        this.processInstanceId = taskSum.getProcessInstanceId();
        this.name = taskSum.getName();
        this.subject = taskSum.getSubject();
        this.description = taskSum.getDescription();
        this.status = taskSum.getStatus();
        this.priority = taskSum.getPriority();
        this.skipable = taskSum.isSkipable();
        User actual = taskSum.getActualOwner();
        if (actual != null) {
            this.actualOwnerId = actual.getId();
        }
        if ((created = taskSum.getCreatedBy()) != null) {
            this.createdById = created.getId();
        }
        this.createdOn = taskSum.getCreatedOn();
        this.activationTime = taskSum.getActivationTime();
        this.expirationTime = taskSum.getExpirationTime();
        this.processId = taskSum.getProcessId();
        this.processSessionId = taskSum.getProcessSessionId();
        this.deploymentId = taskSum.getDeploymentId();
        this.quickTaskSummary = false;
    }

    public JaxbTaskSummary() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        AbstractJaxbTaskObject.unsupported(Task.class);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isSkipable() {
        return this.skipable;
    }

    public void setSkipable(boolean skipable) {
        this.skipable = skipable;
    }

    @JsonIgnore
    public User getActualOwner() {
        if (this.actualOwnerId == null) {
            return null;
        }
        return new AbstractJaxbTaskObject.GetterUser(this.actualOwnerId);
    }

    public void setActualOwner(User actualOwner) {
        this.actualOwnerId = actualOwner != null ? actualOwner.getId() : null;
    }

    public String getActualOwnerId() {
        return this.actualOwnerId;
    }

    public void setActualOwnerId(String id) {
        this.actualOwnerId = id;
    }

    @JsonIgnore
    public User getCreatedBy() {
        if (this.createdById == null) {
            return null;
        }
        return new AbstractJaxbTaskObject.GetterUser(this.createdById);
    }

    public void setCreatedBy(User createdBy) {
        this.createdById = createdBy != null ? createdBy.getId() : null;
    }

    public String getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(String id) {
        this.createdById = id;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public int getProcessSessionId() {
        return this.processSessionId;
    }

    public void setProcessSessionId(int processSessionId) {
        this.processSessionId = processSessionId;
    }

    public List<String> getPotentialOwners() {
        return this.potentialOwners;
    }

    public void setPotentialOwners(List<String> potentialOwners) {
        this.potentialOwners = potentialOwners;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getStatusId() {
        return this.status != null ? this.status.name() : "";
    }

    public boolean isQuickTaskSummary() {
        return this.quickTaskSummary;
    }

    public long getParentId() {
        return this.parentId;
    }
}

